/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.shaded.apache.logging.log4j.core.pattern;

import co.elastic.apm.agent.shaded.apache.logging.log4j.core.LogEvent;
import co.elastic.apm.agent.shaded.apache.logging.log4j.core.config.plugins.Plugin;
import co.elastic.apm.agent.shaded.apache.logging.log4j.core.impl.LocationAware;
import co.elastic.apm.agent.shaded.apache.logging.log4j.core.pattern.ConverterKeys;
import co.elastic.apm.agent.shaded.apache.logging.log4j.core.pattern.NamePatternConverter;

@Plugin(name="ClassNamePatternConverter", category="Converter")
@ConverterKeys(value={"C", "class"})
public final class ClassNamePatternConverter
extends NamePatternConverter
implements LocationAware {
    private static final String NA = "?";

    private ClassNamePatternConverter(String[] options) {
        super("Class Name", "class name", options);
    }

    public static ClassNamePatternConverter newInstance(String[] options) {
        return new ClassNamePatternConverter(options);
    }

    @Override
    public void format(LogEvent event, StringBuilder toAppendTo) {
        StackTraceElement element = event.getSource();
        if (element == null) {
            toAppendTo.append(NA);
        } else {
            this.abbreviate(element.getClassName(), toAppendTo);
        }
    }

    @Override
    public boolean requiresLocation() {
        return true;
    }
}

