/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.shaded.apache.logging.log4j.core.util;

import co.elastic.apm.agent.shaded.apache.logging.log4j.Logger;
import co.elastic.apm.agent.shaded.apache.logging.log4j.core.util.AuthorizationProvider;
import co.elastic.apm.agent.shaded.apache.logging.log4j.core.util.PasswordDecryptor;
import co.elastic.apm.agent.shaded.apache.logging.log4j.status.StatusLogger;
import co.elastic.apm.agent.shaded.apache.logging.log4j.util.Base64Util;
import co.elastic.apm.agent.shaded.apache.logging.log4j.util.LoaderUtil;
import co.elastic.apm.agent.shaded.apache.logging.log4j.util.PropertiesUtil;
import java.net.URLConnection;

public class BasicAuthorizationProvider
implements AuthorizationProvider {
    public static final String CONFIG_USER_NAME = "elasticapmlog4j2.configurationUserName";
    public static final String CONFIG_PASSWORD = "elasticapmlog4j2.configurationPassword";
    public static final String PASSWORD_DECRYPTOR = "elasticapmlog4j2.passwordDecryptor";
    private static Logger LOGGER = StatusLogger.getLogger();
    private String authString = null;

    public BasicAuthorizationProvider(PropertiesUtil props) {
        String userName = props.getStringProperty(CONFIG_USER_NAME);
        String password = props.getStringProperty(CONFIG_PASSWORD);
        String decryptor = props.getStringProperty(PASSWORD_DECRYPTOR);
        if (decryptor != null) {
            try {
                Object obj = LoaderUtil.newInstanceOf(decryptor);
                if (obj instanceof PasswordDecryptor) {
                    password = ((PasswordDecryptor)obj).decryptPassword(password);
                }
            }
            catch (Exception ex) {
                LOGGER.warn("Unable to decrypt password.", (Throwable)ex);
            }
        }
        if (userName != null && password != null) {
            this.authString = "Basic " + Base64Util.encode(userName + ":" + password);
        }
    }

    @Override
    public void addAuthorization(URLConnection urlConnection) {
        if (this.authString != null) {
            urlConnection.setRequestProperty("Authorization", this.authString);
        }
    }
}

