/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.shaded.apache.logging.log4j.core.util;

import co.elastic.apm.agent.shaded.apache.logging.log4j.core.util.Clock;
import co.elastic.apm.agent.shaded.apache.logging.log4j.core.util.Log4jThread;
import java.util.concurrent.locks.LockSupport;

public final class CachedClock
implements Clock {
    private static final int UPDATE_THRESHOLD = 1000;
    private static volatile CachedClock instance;
    private static final Object INSTANCE_LOCK;
    private volatile long millis = System.currentTimeMillis();
    private short count = 0;

    private CachedClock() {
        Log4jThread updater = new Log4jThread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    long time = System.currentTimeMillis();
                    CachedClock.this.millis = time;
                    LockSupport.parkNanos(1000000L);
                }
            }
        }, "CachedClock Updater Thread");
        updater.setDaemon(true);
        updater.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CachedClock instance() {
        CachedClock result = instance;
        if (result == null) {
            Object object = INSTANCE_LOCK;
            synchronized (object) {
                result = instance;
                if (result == null) {
                    instance = result = new CachedClock();
                }
            }
        }
        return result;
    }

    @Override
    public long currentTimeMillis() {
        this.count = (short)(this.count + 1);
        if (this.count > 1000) {
            this.millis = System.currentTimeMillis();
            this.count = 0;
        }
        return this.millis;
    }

    static {
        INSTANCE_LOCK = new Object();
    }
}

