/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.shaded.apache.logging.log4j.core.util;

import co.elastic.apm.agent.shaded.apache.logging.log4j.core.config.ConfigurationSource;
import java.io.File;
import java.net.URI;
import java.util.Objects;

public class Source {
    private final File file;
    private final URI uri;
    private final String location;

    public Source(ConfigurationSource source) {
        this.file = source.getFile();
        this.uri = source.getURI();
        this.location = source.getLocation();
    }

    public Source(File file) {
        this.file = Objects.requireNonNull(file, "file is null");
        this.location = file.getAbsolutePath();
        this.uri = null;
    }

    public Source(URI uri, long lastModified) {
        this.uri = Objects.requireNonNull(uri, "URI is null");
        this.location = uri.toString();
        this.file = null;
    }

    public File getFile() {
        return this.file;
    }

    public URI getURI() {
        return this.uri;
    }

    public String getLocation() {
        return this.location;
    }

    public String toString() {
        return this.location;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Source)) {
            return false;
        }
        Source source = (Source)o;
        return Objects.equals(this.location, source.location);
    }

    public int hashCode() {
        return Objects.hash(this.location);
    }
}

