/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.shaded.jctools.queues.atomic;

import co.elastic.apm.agent.shaded.jctools.queues.MessagePassingQueue;
import co.elastic.apm.agent.shaded.jctools.queues.atomic.SpscAtomicArrayQueueL3Pad;
import java.util.concurrent.atomic.AtomicReferenceArray;

public class SpscAtomicArrayQueue<E>
extends SpscAtomicArrayQueueL3Pad<E> {
    public SpscAtomicArrayQueue(int capacity) {
        super(Math.max(capacity, 4));
    }

    @Override
    public boolean offer(E e) {
        if (null == e) {
            throw new NullPointerException();
        }
        AtomicReferenceArray buffer = this.buffer;
        int mask = this.mask;
        long producerIndex = this.producerIndex;
        if (producerIndex >= this.producerLimit && !this.offerSlowPath(buffer, mask, producerIndex)) {
            return false;
        }
        int offset = this.calcElementOffset(producerIndex, mask);
        SpscAtomicArrayQueue.soElement(buffer, offset, e);
        this.soProducerIndex(producerIndex + 1L);
        return true;
    }

    private boolean offerSlowPath(AtomicReferenceArray<E> buffer, int mask, long producerIndex) {
        int lookAheadStep = this.lookAheadStep;
        if (null == SpscAtomicArrayQueue.lvElement(buffer, this.calcElementOffset(producerIndex + (long)lookAheadStep, mask))) {
            this.producerLimit = producerIndex + (long)lookAheadStep;
        } else {
            int offset = this.calcElementOffset(producerIndex, mask);
            if (null != SpscAtomicArrayQueue.lvElement(buffer, offset)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public E poll() {
        AtomicReferenceArray buffer = this.buffer;
        long consumerIndex = this.consumerIndex;
        int offset = this.calcElementOffset(consumerIndex);
        Object e = SpscAtomicArrayQueue.lvElement(buffer, offset);
        if (null == e) {
            return null;
        }
        SpscAtomicArrayQueue.soElement(buffer, offset, null);
        this.soConsumerIndex(consumerIndex + 1L);
        return e;
    }

    @Override
    public E peek() {
        return SpscAtomicArrayQueue.lvElement(this.buffer, this.calcElementOffset(this.consumerIndex));
    }

    @Override
    public boolean relaxedOffer(E message) {
        return this.offer(message);
    }

    @Override
    public E relaxedPoll() {
        return this.poll();
    }

    @Override
    public E relaxedPeek() {
        return this.peek();
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> c) {
        return this.drain(c, this.capacity());
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s) {
        return this.fill(s, this.capacity());
    }

    @Override
    public int drain(MessagePassingQueue.Consumer<E> c, int limit) {
        AtomicReferenceArray buffer = this.buffer;
        int mask = this.mask;
        long consumerIndex = this.consumerIndex;
        for (int i = 0; i < limit; ++i) {
            long index = consumerIndex + (long)i;
            int offset = this.calcElementOffset(index, mask);
            Object e = SpscAtomicArrayQueue.lvElement(buffer, offset);
            if (null == e) {
                return i;
            }
            SpscAtomicArrayQueue.soElement(buffer, offset, null);
            this.soConsumerIndex(index + 1L);
            c.accept(e);
        }
        return limit;
    }

    @Override
    public int fill(MessagePassingQueue.Supplier<E> s, int limit) {
        AtomicReferenceArray buffer = this.buffer;
        int mask = this.mask;
        int lookAheadStep = this.lookAheadStep;
        long producerIndex = this.producerIndex;
        for (int i = 0; i < limit; ++i) {
            long index = producerIndex + (long)i;
            int lookAheadElementOffset = this.calcElementOffset(index + (long)lookAheadStep, mask);
            if (null == SpscAtomicArrayQueue.lvElement(buffer, lookAheadElementOffset)) {
                int lookAheadLimit = Math.min(lookAheadStep, limit - i);
                for (int j = 0; j < lookAheadLimit; ++j) {
                    int offset = this.calcElementOffset(index + (long)j, mask);
                    SpscAtomicArrayQueue.soElement(buffer, offset, s.get());
                    this.soProducerIndex(index + (long)j + 1L);
                }
                i += lookAheadLimit - 1;
                continue;
            }
            int offset = this.calcElementOffset(index, mask);
            if (null != SpscAtomicArrayQueue.lvElement(buffer, offset)) {
                return i;
            }
            SpscAtomicArrayQueue.soElement(buffer, offset, s.get());
            this.soProducerIndex(index + 1L);
        }
        return limit;
    }

    @Override
    public void drain(MessagePassingQueue.Consumer<E> c, MessagePassingQueue.WaitStrategy w, MessagePassingQueue.ExitCondition exit) {
        AtomicReferenceArray buffer = this.buffer;
        int mask = this.mask;
        long consumerIndex = this.consumerIndex;
        int counter = 0;
        while (exit.keepRunning()) {
            for (int i = 0; i < 4096; ++i) {
                int offset = this.calcElementOffset(consumerIndex, mask);
                Object e = SpscAtomicArrayQueue.lvElement(buffer, offset);
                if (null == e) {
                    counter = w.idle(counter);
                    continue;
                }
                counter = 0;
                SpscAtomicArrayQueue.soElement(buffer, offset, null);
                this.soConsumerIndex(++consumerIndex);
                c.accept(e);
            }
        }
    }

    @Override
    public void fill(MessagePassingQueue.Supplier<E> s, MessagePassingQueue.WaitStrategy w, MessagePassingQueue.ExitCondition e) {
        AtomicReferenceArray buffer = this.buffer;
        int mask = this.mask;
        int lookAheadStep = this.lookAheadStep;
        long producerIndex = this.producerIndex;
        int counter = 0;
        while (e.keepRunning()) {
            int lookAheadElementOffset = this.calcElementOffset(producerIndex + (long)lookAheadStep, mask);
            if (null == SpscAtomicArrayQueue.lvElement(buffer, lookAheadElementOffset)) {
                for (int j = 0; j < lookAheadStep; ++j) {
                    int offset = this.calcElementOffset(producerIndex, mask);
                    SpscAtomicArrayQueue.soElement(buffer, offset, s.get());
                    this.soProducerIndex(++producerIndex);
                }
                continue;
            }
            int offset = this.calcElementOffset(producerIndex, mask);
            if (null != SpscAtomicArrayQueue.lvElement(buffer, offset)) {
                counter = w.idle(counter);
                continue;
            }
            counter = 0;
            SpscAtomicArrayQueue.soElement(buffer, offset, s.get());
            this.soProducerIndex(++producerIndex);
        }
    }
}

