/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.shaded.logging.log4j2;

import co.elastic.apm.agent.shaded.apache.logging.log4j.Marker;
import co.elastic.apm.agent.shaded.apache.logging.log4j.core.LogEvent;
import co.elastic.apm.agent.shaded.apache.logging.log4j.core.config.Configuration;
import co.elastic.apm.agent.shaded.apache.logging.log4j.core.config.plugins.Plugin;
import co.elastic.apm.agent.shaded.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import co.elastic.apm.agent.shaded.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import co.elastic.apm.agent.shaded.apache.logging.log4j.core.config.plugins.PluginElement;
import co.elastic.apm.agent.shaded.apache.logging.log4j.core.layout.AbstractStringLayout;
import co.elastic.apm.agent.shaded.apache.logging.log4j.core.layout.ByteBufferDestination;
import co.elastic.apm.agent.shaded.apache.logging.log4j.core.layout.Encoder;
import co.elastic.apm.agent.shaded.apache.logging.log4j.core.layout.PatternLayout;
import co.elastic.apm.agent.shaded.apache.logging.log4j.core.lookup.StrSubstitutor;
import co.elastic.apm.agent.shaded.apache.logging.log4j.core.pattern.PatternFormatter;
import co.elastic.apm.agent.shaded.apache.logging.log4j.core.util.KeyValuePair;
import co.elastic.apm.agent.shaded.apache.logging.log4j.message.Message;
import co.elastic.apm.agent.shaded.apache.logging.log4j.message.MultiformatMessage;
import co.elastic.apm.agent.shaded.apache.logging.log4j.message.ObjectMessage;
import co.elastic.apm.agent.shaded.apache.logging.log4j.util.MultiFormatStringBuilderFormattable;
import co.elastic.apm.agent.shaded.apache.logging.log4j.util.StringBuilderFormattable;
import co.elastic.apm.agent.shaded.apache.logging.log4j.util.TriConsumer;
import co.elastic.apm.agent.shaded.logging.EcsJsonSerializer;
import co.elastic.apm.agent.shaded.logging.JsonUtils;
import co.elastic.apm.agent.shaded.logging.log4j2.ObjectMessageJacksonSerializer;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@Plugin(name="EcsLayout", category="Core", elementType="layout")
public class EcsLayout
extends AbstractStringLayout {
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    public static final String[] JSON_FORMAT = new String[]{"JSON"};
    private final TriConsumer<String, Object, StringBuilder> WRITE_MDC = new TriConsumer<String, Object, StringBuilder>(){

        @Override
        public void accept(String key, Object value, StringBuilder stringBuilder) {
            stringBuilder.append('\"');
            JsonUtils.quoteAsString(key, stringBuilder);
            stringBuilder.append("\":\"");
            JsonUtils.quoteAsString(EcsJsonSerializer.toNullSafeString(String.valueOf(value)), stringBuilder);
            stringBuilder.append("\",");
        }
    };
    private final KeyValuePair[] additionalFields;
    private final PatternFormatter[][] fieldValuePatternFormatter;
    private final boolean stackTraceAsArray;
    private final String serviceName;
    private final String eventDataset;
    private final boolean includeMarkers;
    private final boolean includeOrigin;
    private final ConcurrentMap<Class<? extends MultiformatMessage>, Boolean> supportsJson = new ConcurrentHashMap<Class<? extends MultiformatMessage>, Boolean>();
    private final ObjectMessageJacksonSerializer objectMessageJacksonSerializer = ObjectMessageJacksonSerializer.Resolver.INSTANCE.resolve();

    private EcsLayout(Configuration config, String serviceName, String eventDataset, boolean includeMarkers, KeyValuePair[] additionalFields, boolean includeOrigin, boolean stackTraceAsArray) {
        super(config, UTF_8, null, null);
        this.serviceName = serviceName;
        this.eventDataset = eventDataset;
        this.includeMarkers = includeMarkers;
        this.includeOrigin = includeOrigin;
        this.stackTraceAsArray = stackTraceAsArray;
        this.additionalFields = additionalFields;
        this.fieldValuePatternFormatter = new PatternFormatter[additionalFields.length][];
        for (int i = 0; i < additionalFields.length; ++i) {
            KeyValuePair additionalField = additionalFields[i];
            if (!additionalField.getValue().contains("%")) continue;
            this.fieldValuePatternFormatter[i] = PatternLayout.createPatternParser(config).parse(additionalField.getValue()).toArray(new PatternFormatter[0]);
        }
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return (Builder)new Builder().asBuilder();
    }

    private static boolean valueNeedsLookup(String value) {
        return value != null && value.contains("${");
    }

    @Override
    public String toSerializable(LogEvent event) {
        StringBuilder text = this.toText(event, EcsLayout.getStringBuilder(), false);
        return text.toString();
    }

    @Override
    public void encode(LogEvent event, ByteBufferDestination destination) {
        StringBuilder text = this.toText(event, EcsLayout.getStringBuilder(), true);
        Encoder<StringBuilder> helper = this.getStringBuilderEncoder();
        helper.encode(text, destination);
    }

    private StringBuilder toText(LogEvent event, StringBuilder builder, boolean gcFree) {
        EcsJsonSerializer.serializeObjectStart(builder, event.getTimeMillis());
        EcsJsonSerializer.serializeLogLevel(builder, event.getLevel().toString());
        this.serializeMessage(builder, gcFree, event.getMessage(), event.getThrown());
        EcsJsonSerializer.serializeServiceName(builder, this.serviceName);
        EcsJsonSerializer.serializeEventDataset(builder, this.eventDataset);
        EcsJsonSerializer.serializeThreadName(builder, event.getThreadName());
        EcsJsonSerializer.serializeLoggerName(builder, event.getLoggerName());
        this.serializeAdditionalFieldsAndMDC(event, builder);
        this.serializeTags(event, builder);
        if (this.includeOrigin) {
            EcsJsonSerializer.serializeOrigin(builder, event.getSource());
        }
        EcsJsonSerializer.serializeException(builder, event.getThrown(), this.stackTraceAsArray);
        EcsJsonSerializer.serializeObjectEnd(builder);
        return builder;
    }

    private void serializeAdditionalFieldsAndMDC(LogEvent event, StringBuilder builder) {
        int length = this.additionalFields.length;
        if (!event.getContextData().isEmpty() || length > 0) {
            if (length > 0) {
                StrSubstitutor strSubstitutor = this.getConfiguration().getStrSubstitutor();
                for (int i = 0; i < length; ++i) {
                    KeyValuePair additionalField = this.additionalFields[i];
                    PatternFormatter[] formatters = this.fieldValuePatternFormatter[i];
                    CharSequence value = null;
                    if (formatters != null) {
                        StringBuilder buffer = EcsJsonSerializer.getMessageStringBuilder();
                        EcsLayout.formatPattern(event, formatters, buffer);
                        if (buffer.length() > 0) {
                            value = buffer;
                        }
                    } else if (EcsLayout.valueNeedsLookup(additionalField.getValue())) {
                        StringBuilder lookupValue = EcsJsonSerializer.getMessageStringBuilder();
                        lookupValue.append(additionalField.getValue());
                        if (strSubstitutor.replaceIn(event, lookupValue)) {
                            value = lookupValue;
                        }
                    } else {
                        value = additionalField.getValue();
                    }
                    if (value == null) continue;
                    builder.append('\"');
                    JsonUtils.quoteAsString(additionalField.getKey(), builder);
                    builder.append("\":\"");
                    JsonUtils.quoteAsString(EcsJsonSerializer.toNullSafeString(value), builder);
                    builder.append("\",");
                }
            }
            event.getContextData().forEach(this.WRITE_MDC, builder);
        }
    }

    private static void formatPattern(LogEvent event, PatternFormatter[] formatters, StringBuilder buffer) {
        int len = formatters.length;
        for (int i = 0; i < len; ++i) {
            formatters[i].format(event, buffer);
        }
    }

    private void serializeTags(LogEvent event, StringBuilder builder) {
        boolean hasTags;
        List<String> contextStack = event.getContextStack().asList();
        Marker marker = event.getMarker();
        boolean bl = hasTags = !contextStack.isEmpty() || this.includeMarkers && marker != null;
        if (hasTags) {
            EcsJsonSerializer.serializeTagStart(builder);
        }
        if (!contextStack.isEmpty()) {
            int len = contextStack.size();
            for (int i = 0; i < len; ++i) {
                builder.append('\"');
                JsonUtils.quoteAsString(contextStack.get(i), builder);
                builder.append("\",");
            }
        }
        if (this.includeMarkers && marker != null) {
            this.serializeMarker(builder, marker);
        }
        if (hasTags) {
            EcsJsonSerializer.serializeTagEnd(builder);
        }
    }

    private void serializeMarker(StringBuilder builder, Marker marker) {
        EcsJsonSerializer.serializeSingleTag(builder, marker.getName());
        if (marker.hasParents()) {
            Marker[] parents = marker.getParents();
            for (int i = 0; i < parents.length; ++i) {
                this.serializeMarker(builder, parents[i]);
            }
        }
    }

    private void serializeMessage(StringBuilder builder, boolean gcFree, Message message, Throwable thrown) {
        if (message instanceof MultiformatMessage) {
            MultiformatMessage multiformatMessage = (MultiformatMessage)message;
            if (this.supportsJson(multiformatMessage)) {
                EcsLayout.serializeJsonMessage(builder, multiformatMessage);
            } else {
                this.serializeSimpleMessage(builder, gcFree, message, thrown);
            }
        } else if (this.objectMessageJacksonSerializer != null && message instanceof ObjectMessage) {
            StringBuilder jsonBuffer = EcsJsonSerializer.getMessageStringBuilder();
            this.objectMessageJacksonSerializer.formatTo(jsonBuffer, (ObjectMessage)message);
            EcsLayout.addJson(builder, jsonBuffer);
        } else {
            this.serializeSimpleMessage(builder, gcFree, message, thrown);
        }
    }

    private static void serializeJsonMessage(StringBuilder builder, MultiformatMessage message) {
        StringBuilder messageBuffer = EcsJsonSerializer.getMessageStringBuilder();
        if (message instanceof MultiFormatStringBuilderFormattable) {
            ((MultiFormatStringBuilderFormattable)message).formatTo(JSON_FORMAT, messageBuffer);
        } else {
            messageBuffer.append(message.getFormattedMessage(JSON_FORMAT));
        }
        EcsLayout.addJson(builder, messageBuffer);
    }

    private static void addJson(StringBuilder buffer, StringBuilder jsonBuffer) {
        if (EcsLayout.isObject(jsonBuffer)) {
            EcsLayout.moveToRoot(jsonBuffer);
            buffer.append((CharSequence)jsonBuffer);
            buffer.append(", ");
        } else {
            buffer.append("\"message\":");
            if (EcsLayout.isString(jsonBuffer)) {
                buffer.append((CharSequence)jsonBuffer);
            } else {
                buffer.append('\"');
                JsonUtils.quoteAsString(jsonBuffer, buffer);
                buffer.append('\"');
            }
            buffer.append(", ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serializeSimpleMessage(StringBuilder builder, boolean gcFree, Message message, Throwable thrown) {
        builder.append("\"message\":\"");
        if (message instanceof CharSequence) {
            JsonUtils.quoteAsString((CharSequence)((Object)message), builder);
        } else if (gcFree && message instanceof StringBuilderFormattable) {
            StringBuilder messageBuffer = EcsJsonSerializer.getMessageStringBuilder();
            try {
                ((StringBuilderFormattable)((Object)message)).formatTo(messageBuffer);
                JsonUtils.quoteAsString(messageBuffer, builder);
            }
            finally {
                EcsLayout.trimToMaxSize(messageBuffer);
            }
        } else {
            JsonUtils.quoteAsString(EcsJsonSerializer.toNullSafeString(message.getFormattedMessage()), builder);
        }
        builder.append("\", ");
    }

    private static boolean isObject(StringBuilder messageBuffer) {
        return messageBuffer.length() > 1 && messageBuffer.charAt(0) == '{' && messageBuffer.charAt(messageBuffer.length() - 1) == '}';
    }

    private static boolean isString(StringBuilder messageBuffer) {
        return messageBuffer.length() > 1 && messageBuffer.charAt(0) == '\"' && messageBuffer.charAt(messageBuffer.length() - 1) == '\"';
    }

    private static void moveToRoot(StringBuilder messageBuffer) {
        messageBuffer.setCharAt(0, ' ');
        messageBuffer.setCharAt(messageBuffer.length() - 1, ' ');
    }

    private boolean supportsJson(MultiformatMessage message) {
        Boolean supportsJson = (Boolean)this.supportsJson.get(message.getClass());
        if (supportsJson == null) {
            supportsJson = false;
            for (String format : message.getFormats()) {
                if (!format.equalsIgnoreCase("JSON")) continue;
                supportsJson = true;
                break;
            }
            this.supportsJson.put(message.getClass(), supportsJson);
        }
        return supportsJson;
    }

    public static class Builder
    extends AbstractStringLayout.Builder<Builder>
    implements co.elastic.apm.agent.shaded.apache.logging.log4j.core.util.Builder<EcsLayout> {
        @PluginBuilderAttribute(value="serviceName")
        private String serviceName;
        @PluginBuilderAttribute(value="eventDataset")
        private String eventDataset;
        @PluginBuilderAttribute(value="includeMarkers")
        private boolean includeMarkers = false;
        @PluginBuilderAttribute(value="stackTraceAsArray")
        private boolean stackTraceAsArray = false;
        @PluginElement(value="AdditionalField")
        private KeyValuePair[] additionalFields = new KeyValuePair[0];
        @PluginBuilderAttribute(value="includeOrigin")
        private boolean includeOrigin = false;

        Builder() {
            this.setCharset(UTF_8);
        }

        public KeyValuePair[] getAdditionalFields() {
            return this.additionalFields;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public String getEventDataset() {
            return this.eventDataset;
        }

        public boolean isIncludeMarkers() {
            return this.includeMarkers;
        }

        public boolean isIncludeOrigin() {
            return this.includeOrigin;
        }

        public Builder setAdditionalFields(KeyValuePair[] additionalFields) {
            this.additionalFields = additionalFields;
            return (Builder)this.asBuilder();
        }

        public Builder setServiceName(String serviceName) {
            this.serviceName = serviceName;
            return (Builder)this.asBuilder();
        }

        public Builder setEventDataset(String eventDataset) {
            this.eventDataset = eventDataset;
            return (Builder)this.asBuilder();
        }

        public Builder setIncludeMarkers(boolean includeMarkers) {
            this.includeMarkers = includeMarkers;
            return (Builder)this.asBuilder();
        }

        public Builder setIncludeOrigin(boolean includeOrigin) {
            this.includeOrigin = includeOrigin;
            return (Builder)this.asBuilder();
        }

        public Builder setStackTraceAsArray(boolean stackTraceAsArray) {
            this.stackTraceAsArray = stackTraceAsArray;
            return (Builder)this.asBuilder();
        }

        @Override
        public EcsLayout build() {
            return new EcsLayout(this.getConfiguration(), this.serviceName, EcsJsonSerializer.computeEventDataset(this.eventDataset, this.serviceName), this.includeMarkers, this.additionalFields, this.includeOrigin, this.stackTraceAsArray);
        }

        public boolean isStackTraceAsArray() {
            return this.stackTraceAsArray;
        }
    }
}

