/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.shaded.logging.log4j2;

import co.elastic.apm.agent.shaded.apache.logging.log4j.core.util.StringBuilderWriter;
import co.elastic.apm.agent.shaded.apache.logging.log4j.message.ObjectMessage;
import co.elastic.apm.agent.shaded.apache.logging.log4j.status.StatusLogger;
import co.elastic.apm.agent.shaded.logging.log4j2.ObjectMapperFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.ServiceLoader;

interface ObjectMessageJacksonSerializer {
    public void formatTo(StringBuilder var1, ObjectMessage var2);

    public static enum Available implements ObjectMessageJacksonSerializer
    {
        INSTANCE;

        private final ObjectMapper objectMapper;

        private Available() {
            ObjectMapper mapper = null;
            Iterator<ObjectMapperFactory> iterator = ServiceLoader.load(ObjectMapperFactory.class, ObjectMessageJacksonSerializer.class.getClassLoader()).iterator();
            if (iterator.hasNext()) {
                ObjectMapperFactory objectMapperFactory = iterator.next();
                mapper = objectMapperFactory.create();
            }
            if (mapper == null) {
                mapper = new ObjectMapper().disable(SerializationFeature.FAIL_ON_EMPTY_BEANS).findAndRegisterModules();
            }
            this.objectMapper = mapper;
        }

        @Override
        public void formatTo(StringBuilder buffer, ObjectMessage objectMessage) {
            try {
                this.objectMapper.writeValue((Writer)new StringBuilderWriter(buffer), objectMessage.getParameter());
            }
            catch (IOException e) {
                StatusLogger.getLogger().catching(e);
                objectMessage.formatTo(buffer);
            }
        }
    }

    public static enum Resolver {
        INSTANCE;


        ObjectMessageJacksonSerializer resolve() {
            Object localDelegate = null;
            try {
                Class.forName("com.fasterxml.jackson.databind.ObjectMapper");
                Class.forName("co.elastic.apm.agent.shaded.apache.logging.log4j.message.ObjectMessage").getMethod("getParameter", new Class[0]);
                return (ObjectMessageJacksonSerializer)Class.forName("co.elastic.apm.agent.shaded.logging.log4j2.ObjectMessageJacksonSerializer$Available").getEnumConstants()[0];
            }
            catch (Exception e) {
                return null;
            }
            catch (LinkageError e) {
                return null;
            }
        }
    }
}

