/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.urlconnection;

import co.elastic.apm.agent.impl.transaction.HeaderGetter;
import co.elastic.apm.agent.impl.transaction.TextHeaderGetter;
import co.elastic.apm.agent.impl.transaction.TextHeaderSetter;
import java.net.HttpURLConnection;
import java.util.List;
import javax.annotation.Nullable;

public class UrlConnectionPropertyAccessor
implements TextHeaderSetter<HttpURLConnection>,
TextHeaderGetter<HttpURLConnection> {
    private static final UrlConnectionPropertyAccessor INSTANCE = new UrlConnectionPropertyAccessor();

    public static UrlConnectionPropertyAccessor instance() {
        return INSTANCE;
    }

    @Override
    public void setHeader(String headerName, String headerValue, HttpURLConnection urlConnection) {
        urlConnection.addRequestProperty(headerName, headerValue);
    }

    @Override
    @Nullable
    public String getFirstHeader(String headerName, HttpURLConnection urlConnection) {
        return urlConnection.getRequestProperty(headerName);
    }

    @Override
    public <S> void forEach(String headerName, HttpURLConnection carrier, S state, HeaderGetter.HeaderConsumer<String, S> consumer) {
        List<String> values = carrier.getRequestProperties().get(headerName);
        if (values != null) {
            int size = values.size();
            for (int i = 0; i < size; ++i) {
                consumer.accept(values.get(i), state);
            }
        }
    }
}

