/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.premain;

import co.elastic.apm.agent.premain.BootstrapCheck;
import co.elastic.apm.agent.premain.JavaVersionBootstrapCheck;
import co.elastic.apm.agent.premain.VerifyNoneBootstrapCheck;
import co.elastic.apm.agent.premain.common.JvmRuntimeInfo;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.List;

class BootstrapChecks {
    private final List<BootstrapCheck> bootstrapChecks;
    private final boolean bootstrapChecksEnabled;

    BootstrapChecks(boolean bootstrapChecksEnabled, BootstrapCheck ... bootstrapChecks) {
        this.bootstrapChecks = Arrays.asList(bootstrapChecks);
        this.bootstrapChecksEnabled = bootstrapChecksEnabled;
    }

    static BootstrapChecks defaults() {
        return new BootstrapChecks(!Boolean.parseBoolean(System.getProperty("elastic.apm.disable_bootstrap_checks")), new JavaVersionBootstrapCheck(JvmRuntimeInfo.ofCurrentVM()), new VerifyNoneBootstrapCheck(ManagementFactory.getRuntimeMXBean()));
    }

    boolean isPassing() {
        BootstrapCheck.BootstrapCheckResult result = new BootstrapCheck.BootstrapCheckResult();
        for (BootstrapCheck check : this.bootstrapChecks) {
            check.doBootstrapCheck(result);
        }
        if (result.isEmpty()) {
            return true;
        }
        boolean isPassing = true;
        if (result.hasErrors()) {
            if (this.bootstrapChecksEnabled) {
                isPassing = false;
                System.err.println("[elastic-apm-agent] WARN Failed to start agent because of failing bootstrap checks.");
                System.err.println("[elastic-apm-agent] INFO To override Java version verification, set the 'elastic.apm.disable_bootstrap_checks' System property to 'true'.");
            } else {
                System.err.println("[elastic-apm-agent] WARN Bootstrap checks have failed. The agent will still start because bootstrap check have been disabled.");
            }
            System.err.println("[elastic-apm-agent] INFO Note that we can not offer support for issues related to disabled bootstrap checks.");
            for (String msg : result.getErrors()) {
                System.err.println("[elastic-apm-agent] ERROR " + msg);
            }
        }
        if (result.hasWarnings()) {
            for (String msg : result.getWarnings()) {
                System.err.println("[elastic-apm-agent] WARN " + msg);
            }
        }
        return isPassing;
    }
}

