/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.premain;

import co.elastic.apm.agent.premain.BootstrapCheck;
import java.lang.management.RuntimeMXBean;
import java.util.List;

public class VerifyNoneBootstrapCheck
implements BootstrapCheck {
    private final RuntimeMXBean runtimeMXBean;

    public VerifyNoneBootstrapCheck(RuntimeMXBean runtimeMXBean) {
        this.runtimeMXBean = runtimeMXBean;
    }

    @Override
    public void doBootstrapCheck(BootstrapCheck.BootstrapCheckResult result) {
        List<String> inputArguments = this.runtimeMXBean.getInputArguments();
        if (inputArguments.contains("-Xverify:none") || inputArguments.contains("-noverify")) {
            result.addWarn("WARNING: -Xverify:none and -noverify are not supported by the Elastic APM Java Agent. In an upcoming version, the agent will not start when these flags are set, unless the system property elastic.apm.disable_bootstrap_checks is set to true.");
        }
    }
}

