/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fibers.ws.rs.client;

import co.paralleluniverse.fibers.ws.rs.client.FiberClient;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.security.KeyStore;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Configuration;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.glassfish.jersey.jetty.connector.JettyConnectorProvider;
import org.glassfish.jersey.spi.ExecutorServiceProvider;

public class AsyncClientBuilder
extends ClientBuilder {
    private final ClientBuilder clientBuilder;

    protected AsyncClientBuilder(ClientBuilder clientBuilder) {
        this.clientBuilder = clientBuilder;
    }

    public static ClientBuilder newBuilder() {
        return new AsyncClientBuilder(ClientBuilder.newBuilder().withConfig((Configuration)AsyncClientBuilder.addDefaultConfigurations(null)));
    }

    public static Client newClient() {
        return AsyncClientBuilder.newClient(null);
    }

    public static Client newClient(Configuration configuration) {
        return new FiberClient(ClientBuilder.newClient((Configuration)AsyncClientBuilder.addDefaultConfigurations(configuration)));
    }

    private static ClientConfig addDefaultConfigurations(Configuration configuration) {
        ExecutorServiceProvider singleThreadPool = new ExecutorServiceProvider(){
            private ExecutorService tp = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("jersey-puniverse-single-worker-%d").build());

            public ExecutorService getExecutorService() {
                return this.tp;
            }

            public void dispose(ExecutorService es) {
            }
        };
        ClientConfig config = new ClientConfig().property("jersey.config.client.async.threadPoolSize", (Object)20);
        if (configuration != null) {
            config.loadFrom(configuration);
        }
        if (config.getConnectorProvider() == null) {
            config.connectorProvider((ConnectorProvider)new JettyConnectorProvider());
        }
        return config;
    }

    public Client build() {
        return new FiberClient(this.clientBuilder.build());
    }

    public ClientBuilder withConfig(Configuration config) {
        this.clientBuilder.withConfig((Configuration)AsyncClientBuilder.addDefaultConfigurations(config));
        return this;
    }

    public ClientBuilder sslContext(SSLContext sslContext) {
        this.clientBuilder.sslContext(sslContext);
        return this;
    }

    public ClientBuilder keyStore(KeyStore keyStore, char[] password) {
        this.clientBuilder.keyStore(keyStore, password);
        return this;
    }

    public ClientBuilder keyStore(KeyStore keyStore, String password) {
        this.clientBuilder.keyStore(keyStore, password);
        return this;
    }

    public ClientBuilder trustStore(KeyStore trustStore) {
        this.clientBuilder.trustStore(trustStore);
        return this;
    }

    public ClientBuilder hostnameVerifier(HostnameVerifier verifier) {
        this.clientBuilder.hostnameVerifier(verifier);
        return this;
    }

    public ClientBuilder property(String name, Object value) {
        this.clientBuilder.property(name, value);
        return this;
    }

    public ClientBuilder register(Class<?> componentClass) {
        this.clientBuilder.register(componentClass);
        return this;
    }

    public ClientBuilder register(Class<?> componentClass, int priority) {
        this.clientBuilder.register(componentClass, priority);
        return this;
    }

    public ClientBuilder register(Class<?> componentClass, Class<?> ... contracts) {
        this.clientBuilder.register(componentClass, (Class[])contracts);
        return this;
    }

    public ClientBuilder register(Class<?> componentClass, Map<Class<?>, Integer> contracts) {
        this.clientBuilder.register(componentClass, contracts);
        return this;
    }

    public ClientBuilder register(Object component) {
        this.clientBuilder.register(component);
        return this;
    }

    public ClientBuilder register(Object component, int priority) {
        this.clientBuilder.register(component, priority);
        return this;
    }

    public ClientBuilder register(Object component, Class<?> ... contracts) {
        this.clientBuilder.register(component, (Class[])contracts);
        return this;
    }

    public ClientBuilder register(Object component, Map<Class<?>, Integer> contracts) {
        this.clientBuilder.register(component, contracts);
        return this;
    }

    public Configuration getConfiguration() {
        return this.clientBuilder.getConfiguration();
    }

    public int hashCode() {
        return this.clientBuilder.hashCode();
    }

    public boolean equals(Object obj) {
        return this.clientBuilder.equals(obj);
    }

    public String toString() {
        return this.clientBuilder.toString();
    }
}

