/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fibers;

import co.paralleluniverse.common.monitoring.ForkJoinPoolMonitor;
import co.paralleluniverse.common.monitoring.JMXForkJoinPoolMonitor;
import co.paralleluniverse.common.monitoring.MetricsForkJoinPoolMonitor;
import co.paralleluniverse.common.monitoring.MonitorType;
import co.paralleluniverse.concurrent.forkjoin.ExtendedForkJoinWorkerFactory;
import co.paralleluniverse.concurrent.forkjoin.ExtendedForkJoinWorkerThread;
import co.paralleluniverse.concurrent.forkjoin.MonitoredForkJoinPool;
import co.paralleluniverse.concurrent.forkjoin.ParkableForkJoinTask;
import co.paralleluniverse.fibers.Fiber;
import co.paralleluniverse.fibers.FiberScheduler;
import co.paralleluniverse.fibers.FiberTask;
import co.paralleluniverse.fibers.FiberTimedScheduler;
import co.paralleluniverse.fibers.FibersMonitor;
import co.paralleluniverse.fibers.SuspendExecution;
import co.paralleluniverse.fibers.instrument.DontInstrument;
import co.paralleluniverse.strands.Strand;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import jsr166e.ConcurrentHashMapV8;
import jsr166e.ForkJoinPool;
import jsr166e.ForkJoinTask;

public class FiberForkJoinScheduler
extends FiberScheduler {
    private final ForkJoinPool fjPool;
    private final FiberTimedScheduler timer;
    private final Set<FiberWorkerThread> activeThreads = Collections.newSetFromMap(new ConcurrentHashMapV8());

    public FiberForkJoinScheduler(String name, int parallelism, Thread.UncaughtExceptionHandler exceptionHandler, MonitorType monitorType, boolean detailedInfo) {
        super(name, monitorType, detailedInfo);
        this.fjPool = this.createForkJoinPool(name, parallelism, exceptionHandler, monitorType);
        this.timer = this.createTimer(this.fjPool, this.getMonitor());
    }

    public FiberForkJoinScheduler(String name, int parallelism, MonitorType monitorType, boolean detailedInfo) {
        this(name, parallelism, null, monitorType, detailedInfo);
    }

    public FiberForkJoinScheduler(String name, int parallelism) {
        this(name, parallelism, null, null, false);
    }

    private FiberForkJoinScheduler(ForkJoinPool fjPool, FiberTimedScheduler timeService, boolean detailedInfo) {
        super(fjPool instanceof MonitoredForkJoinPool ? ((MonitoredForkJoinPool)fjPool).getName() : null, fjPool instanceof MonitoredForkJoinPool && ((MonitoredForkJoinPool)fjPool).getMonitor() != null ? MonitorType.JMX : MonitorType.NONE, detailedInfo);
        if (!fjPool.getAsyncMode()) {
            throw new IllegalArgumentException("ForkJoinPool is not async");
        }
        this.fjPool = fjPool;
        this.timer = timeService != null ? timeService : this.createTimer(fjPool, this.getMonitor());
    }

    @Override
    public void shutdown() {
        this.timer.shutdown();
        super.shutdown();
    }

    private ForkJoinPool createForkJoinPool(String name, int parallelism, Thread.UncaughtExceptionHandler exceptionHandler, MonitorType monitorType) {
        MonitoredForkJoinPool pool = new MonitoredForkJoinPool(name, parallelism, new ExtendedForkJoinWorkerFactory(name){

            @Override
            protected ExtendedForkJoinWorkerThread createThread(ForkJoinPool pool) {
                return new FiberWorkerThread(pool);
            }
        }, exceptionHandler, true);
        pool.setMonitor(FiberForkJoinScheduler.createForkJoinPoolMonitor(name, pool, monitorType));
        return pool;
    }

    static ForkJoinPoolMonitor createForkJoinPoolMonitor(String name, ForkJoinPool fjPool, MonitorType monitorType) {
        if (monitorType == null) {
            return null;
        }
        switch (monitorType) {
            case JMX: {
                return new JMXForkJoinPoolMonitor(name, fjPool);
            }
            case METRICS: {
                return new MetricsForkJoinPoolMonitor(name, fjPool);
            }
            case NONE: {
                return null;
            }
        }
        throw new RuntimeException("Unsupported monitor type: " + (Object)((Object)monitorType));
    }

    private FiberTimedScheduler createTimer(ForkJoinPool fjPool, FibersMonitor monitor) {
        if (fjPool instanceof MonitoredForkJoinPool) {
            return new FiberTimedScheduler(this, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("FiberTimedScheduler-" + ((MonitoredForkJoinPool)fjPool).getName()).build(), monitor);
        }
        return new FiberTimedScheduler(this);
    }

    public ForkJoinPool getForkJoinPool() {
        return this.fjPool;
    }

    @Override
    public Executor getExecutor() {
        return this.fjPool;
    }

    @Override
    Future<Void> schedule(Fiber<?> fiber, Object blocker, long delay, TimeUnit unit) {
        return this.timer.schedule(fiber, blocker, delay, unit);
    }

    @Override
    <V> FiberTask<V> newFiberTask(Fiber<V> fiber) {
        return new FiberForkJoinTask<V>(fiber, this.fjPool);
    }

    @Override
    Map<Thread, Fiber> getRunningFibers() {
        HashMap<Thread, Fiber> fibers = new HashMap<Thread, Fiber>(this.activeThreads.size() + 2);
        for (FiberWorkerThread t : this.activeThreads) {
            fibers.put(t, FiberForkJoinScheduler.getTargetFiber(t));
        }
        return fibers;
    }

    @Override
    protected int getQueueLength() {
        return this.fjPool.getQueuedSubmissionCount();
    }

    @Override
    int getTimedQueueLength() {
        return this.timer.getQueueLength();
    }

    @Override
    protected final boolean isCurrentThreadInScheduler() {
        return ForkJoinTask.getPool() == this.fjPool;
    }

    public static boolean isFiberThread(Thread t) {
        return t instanceof FiberWorkerThread;
    }

    static Fiber getTargetFiber(Thread thread) {
        Object target = ParkableForkJoinTask.getTarget(thread);
        if (target == null || !(target instanceof Fiber.DummyRunnable)) {
            return null;
        }
        return ((Fiber.DummyRunnable)target).fiber;
    }

    @Override
    void setCurrentFiber(Fiber target, Thread currentThread) {
        if (FiberForkJoinScheduler.isFiberThread(currentThread)) {
            ParkableForkJoinTask.setTarget(currentThread, target.fiberRef);
        } else {
            Fiber.setCurrentStrand(target);
        }
    }

    @Override
    void setCurrentTarget(Object target, Thread currentThread) {
        if (FiberForkJoinScheduler.isFiberThread(currentThread)) {
            ParkableForkJoinTask.setTarget(currentThread, target);
        } else {
            Fiber.setCurrentStrand((Strand)target);
        }
    }

    @Override
    Object getCurrentTarget(Thread currentThread) {
        if (FiberForkJoinScheduler.isFiberThread(currentThread)) {
            return ParkableForkJoinTask.getTarget(currentThread);
        }
        return Fiber.getCurrentStrand();
    }

    void tryOnIdle() {
        if (FiberForkJoinTask.isIdle()) {
            this.onIdle();
        }
    }

    protected void onIdle() {
    }

    static final class FiberForkJoinTask<V>
    extends ParkableForkJoinTask<V>
    implements FiberTask<V> {
        private final ForkJoinPool fjPool;
        private final Fiber<V> fiber;

        public FiberForkJoinTask(Fiber<V> fiber) {
            this(fiber, null);
        }

        public FiberForkJoinTask(Fiber<V> fiber, ForkJoinPool fjPool) {
            this.fiber = fiber;
            this.fjPool = fjPool;
        }

        @Override
        public Fiber<V> getFiber() {
            return this.fiber;
        }

        @Override
        public void submit() {
            if (FiberForkJoinTask.getPool() == this.fjPool) {
                this.fork();
            } else {
                this.fjPool.submit(this);
            }
        }

        @Override
        protected boolean exec1() {
            return this.fiber.exec();
        }

        @Override
        public boolean doExec() {
            boolean done = this.isDone();
            if (!done && (done = super.exec())) {
                this.quietlyComplete();
            }
            return done;
        }

        @Override
        public boolean unpark(Object unblocker) {
            return super.unpark(unblocker == FiberTask.EMERGENCY_UNBLOCKER ? ParkableForkJoinTask.EMERGENCY_UNBLOCKER : unblocker);
        }

        @Override
        @DontInstrument
        public boolean park(Object blocker, boolean exclusive) throws SuspendExecution {
            try {
                return super.park(blocker, exclusive);
            }
            catch (SuspendExecution p) {
                throw p;
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        @DontInstrument
        public void yield() throws SuspendExecution {
            try {
                super.yield();
            }
            catch (SuspendExecution p) {
                throw p;
            }
            catch (Exception e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        protected void parking(boolean yield) {
        }

        @Override
        public void doPark(boolean yield) {
            super.doPark(yield);
        }

        @Override
        protected void onParked(boolean yield) {
            super.onParked(yield);
            this.fiber.onParked();
        }

        @Override
        @DontInstrument
        protected void throwPark(boolean yield) throws SuspendExecution {
            throw yield ? SuspendExecution.YIELD : SuspendExecution.PARK;
        }

        @Override
        protected void onException(Throwable t) {
        }

        @Override
        protected void onCompletion(boolean res) {
        }

        static boolean isIdle() {
            return FiberForkJoinTask.peekNextLocalTask() == null;
        }

        @Override
        public V getRawResult() {
            return this.fiber.getResult();
        }

        @Override
        protected void setRawResult(V v) {
            this.fiber.setResult(v);
        }

        @Override
        public int getState() {
            return super.getState();
        }

        @Override
        public void setState(int state) {
            super.setState(state);
        }

        @Override
        public boolean tryUnpark(Object unblocker) {
            return super.tryUnpark(unblocker);
        }

        @Override
        public Object getUnparker() {
            return super.getUnparker();
        }

        @Override
        public StackTraceElement[] getUnparkStackTrace() {
            return super.getUnparkStackTrace();
        }

        @Override
        public String toString() {
            return super.toString() + "(Fiber@" + this.fiber.getId() + ')';
        }
    }

    private class FiberWorkerThread
    extends ExtendedForkJoinWorkerThread {
        public FiberWorkerThread(ForkJoinPool pool) {
            super(pool);
        }

        @Override
        protected void onStart() {
            super.onStart();
            FiberForkJoinScheduler.this.activeThreads.add(this);
        }

        @Override
        protected void onTermination(Throwable exception) {
            super.onTermination(exception);
            FiberForkJoinScheduler.this.activeThreads.remove(this);
        }
    }
}

