/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.common.util;

import co.paralleluniverse.common.monitoring.FlightRecorder;
import co.paralleluniverse.common.util.SystemProperties;
import co.paralleluniverse.strands.Strand;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class Debug {
    private static final boolean debugMode;
    private static final String FLIGHT_RECORDER_DUMP_FILE;
    private static final FlightRecorder flightRecorder;
    private static boolean recordStackTraces;
    private static final boolean assertionsEnabled;
    private static final boolean unitTest;
    private static final boolean ci;
    private static final boolean debugger;
    private static final AtomicBoolean requestShutdown;
    private static final Lock dumpLock;
    private static final Condition dumpDone;
    private static boolean dumped;
    private static final StackTraceFilter UNITTEST_FILTER;

    public static boolean isDebug() {
        return debugMode;
    }

    public static boolean isCI() {
        return ci;
    }

    public static boolean isDebugger() {
        return debugger;
    }

    public static boolean isAssertionsEnabled() {
        return assertionsEnabled;
    }

    public static boolean isRecordStackTraces() {
        return recordStackTraces;
    }

    public static boolean isUnitTest() {
        return unitTest;
    }

    public static void setRecordStackTraces(boolean recordStackTraces) {
        Debug.recordStackTraces = recordStackTraces;
    }

    public static String getDumpFile() {
        return FLIGHT_RECORDER_DUMP_FILE;
    }

    public static FlightRecorder getGlobalFlightRecorder() {
        return flightRecorder;
    }

    public static void exit() {
        Debug.exit(0, null, null);
    }

    public static void exit(int code) {
        Debug.exit(code, null, null);
    }

    public static void exit(int code, String filename) {
        Debug.exit(code, null, filename);
    }

    public static void exit(Throwable t, String filename) {
        Debug.exit(1, t, filename);
    }

    public static void exit(Throwable t) {
        Debug.exit(1, t, null);
    }

    public static void exit(int code, Throwable t, String filename) {
        Strand currentStrand = Strand.currentStrand();
        if (flightRecorder != null) {
            flightRecorder.record(1, (Object)("DEBUG EXIT REQUEST ON STRAND " + currentStrand + ": " + Arrays.toString(currentStrand.getStackTrace())));
            if (t != null) {
                flightRecorder.record(1, (Object)("CAUSED BY " + t + ": " + Arrays.toString(currentStrand.getStackTrace())));
            }
            flightRecorder.stop();
        }
        if (requestShutdown.compareAndSet(false, true)) {
            System.err.println("DEBUG EXIT REQUEST ON STRAND " + currentStrand + (currentStrand.isFiber() ? " (THREAD " + Thread.currentThread() + ")" : "") + ": SHUTTING DOWN THE JVM.");
            Thread.dumpStack();
            if (t != null) {
                System.err.println("CAUSED BY " + t);
                t.printStackTrace();
            }
            Debug.dumpRecorder(filename);
            if (!Debug.isUnitTest()) {
                System.exit(code);
            }
        }
    }

    public static void record(int level, Object payload) {
        if (!Debug.isDebug()) {
            return;
        }
        if (Debug.getGlobalFlightRecorder() == null) {
            return;
        }
        Debug.getGlobalFlightRecorder().record(level, payload);
    }

    public static void record(int level, Object ... payload) {
        if (!Debug.isDebug()) {
            return;
        }
        if (Debug.getGlobalFlightRecorder() == null) {
            return;
        }
        Debug.getGlobalFlightRecorder().record(level, payload);
    }

    public static void dumpRecorder() {
        Debug.dumpRecorder(null);
    }

    public static void dumpRecorder(String filename) {
        dumpLock.lock();
        try {
            if (!dumped) {
                if (filename == null && (filename = Debug.getDumpFile()).trim().equals("")) {
                    filename = null;
                }
                if (filename == null) {
                    System.err.println("NO ERROR LOG FILE SPECIFIED.");
                    return;
                }
                if (flightRecorder != null) {
                    flightRecorder.dump(filename);
                }
                dumped = true;
                dumpDone.signalAll();
            } else {
                while (!dumped) {
                    dumpDone.await();
                }
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            dumpLock.unlock();
        }
    }

    public static void dumpAfter(long millis) {
        Debug.dumpAfter(millis, FLIGHT_RECORDER_DUMP_FILE);
    }

    public static void dumpAfter(final long millis, final String filename) {
        if (!debugMode) {
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(millis);
                    Debug.dumpRecorder(filename);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }, "DEBUG").start();
    }

    public static void dumpStack() {
        Debug.dumpStack(System.out, new Exception("Stack trace"), UNITTEST_FILTER);
    }

    public static void dumpStack(PrintStream s, Throwable t) {
        Debug.dumpStack(s, t, UNITTEST_FILTER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpStack(PrintStream s, Throwable t, StackTraceFilter filter) {
        PrintStream printStream = s;
        synchronized (printStream) {
            s.println(t);
            StackTraceElement[] trace = t.getStackTrace();
            for (int i = 0; i < trace.length; ++i) {
                if (!filter.filter(trace[i])) continue;
                s.println("\tat " + trace[i]);
            }
            Throwable ourCause = t.getCause();
            if (ourCause != null) {
                Debug.printStackTraceAsCause(s, trace, ourCause, filter);
            }
        }
    }

    private static void printStackTraceAsCause(PrintStream s, StackTraceElement[] causedTrace, Throwable t, StackTraceFilter filter) {
        Throwable ourCause;
        StackTraceElement[] trace = t.getStackTrace();
        int m = trace.length - 1;
        for (int n = causedTrace.length - 1; m >= 0 && n >= 0 && trace[m].equals(causedTrace[n]); --m, --n) {
        }
        int framesInCommon = trace.length - 1 - m;
        s.println("Caused by: " + t);
        for (int i = 0; i <= m; ++i) {
            if (!filter.filter(trace[i])) continue;
            s.println("\tat " + trace[i]);
        }
        if (framesInCommon != 0) {
            s.println("\t... " + framesInCommon + " more");
        }
        if ((ourCause = t.getCause()) != null) {
            Debug.printStackTraceAsCause(s, trace, ourCause, filter);
        }
    }

    private static boolean isEnvTrue(String envVar) {
        String ev = System.getenv(envVar);
        if (ev == null) {
            return false;
        }
        try {
            return Boolean.parseBoolean(ev);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getPackageVersion(String packageName) {
        try {
            Package aPackage = Package.getPackage(packageName);
            if (aPackage != null) {
                return aPackage.getImplementationVersion();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static Path getJarOfClass(String className) {
        return Debug.getJarOfClass(Debug.findClass(className));
    }

    public static Path getJarOfClass(Class<?> clazz) {
        try {
            String p;
            int idx;
            URL resource;
            if (clazz != null && (resource = clazz.getClassLoader().getResource(clazz.getName().replace('.', '/') + ".class")) != null && (idx = (p = resource.toString()).lastIndexOf(33)) > 0) {
                return Paths.get(new URI(p.substring(0, idx)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String whereIs(String className) {
        return Debug.whereIs(Debug.findClass(className));
    }

    public static String whereIs(Class<?> clazz) {
        return clazz != null ? clazz.getClassLoader().getResource(clazz.getName().replace('.', '/') + ".class").toString() : null;
    }

    private static Class findClass(String className) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException classNotFoundException2) {
                return null;
            }
        }
    }

    public static String getClassLoaderInfo(ClassLoader cl) {
        StringBuilder sb = new StringBuilder();
        int indent = 0;
        while (cl != null) {
            Debug.indent(sb, indent).append(cl.toString()).append('\n');
            if (cl instanceof URLClassLoader) {
                Debug.indent(sb, indent).append("URLs: ").append(Arrays.toString(((URLClassLoader)cl).getURLs())).append('\n');
            }
            cl = cl.getParent();
            indent += 4;
        }
        return sb.toString();
    }

    private static StringBuilder indent(StringBuilder sb, int indent) {
        for (int i = 0; i < indent; ++i) {
            sb.append(' ');
        }
        return sb;
    }

    private Debug() {
    }

    static {
        StackTraceElement[] stack;
        debugMode = SystemProperties.isEmptyOrTrue("co.paralleluniverse.debugMode");
        FLIGHT_RECORDER_DUMP_FILE = System.getProperty("co.paralleluniverse.flightRecorderDumpFile");
        flightRecorder = debugMode && SystemProperties.isEmptyOrTrue("co.paralleluniverse.globalFlightRecorder") ? new FlightRecorder("PUNIVERSE-FLIGHT-RECORDER") : null;
        recordStackTraces = false;
        requestShutdown = new AtomicBoolean();
        dumpLock = new ReentrantLock();
        dumpDone = dumpLock.newCondition();
        boolean ea = false;
        if (!$assertionsDisabled) {
            ea = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        assertionsEnabled = ea;
        boolean isUnitTest = false;
        for (StackTraceElement ste : stack = Thread.currentThread().getStackTrace()) {
            if (!ste.getClassName().startsWith("org.junit") && !ste.getClassName().startsWith("junit.framework") && !ste.getClassName().contains("JUnitTestClassExecuter")) continue;
            isUnitTest = true;
            break;
        }
        unitTest = isUnitTest;
        boolean bl = ci = Debug.isEnvTrue("CI") || Debug.isEnvTrue("CONTINUOUS_INTEGRATION") || Debug.isEnvTrue("TRAVIS");
        if (debugMode) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    Debug.dumpRecorder();
                }
            });
        }
        debugger = ManagementFactory.getRuntimeMXBean().getInputArguments().toString().contains("-agentlib:jdwp");
        UNITTEST_FILTER = new StackTraceFilter(){

            @Override
            public boolean filter(StackTraceElement ste) {
                return !ste.getClassName().startsWith("org.mockito") && !ste.getClassName().startsWith("org.junit") && !ste.getClassName().startsWith("org.apache.tools.ant.taskdefs.optional.junit");
            }
        };
    }

    public static interface StackTraceFilter {
        public boolean filter(StackTraceElement var1);
    }
}

