/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fibers.instrument;

import co.paralleluniverse.asm.Type;
import co.paralleluniverse.asm.tree.MethodInsnNode;
import co.paralleluniverse.fibers.Instrumented;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

final class Classes {
    static final String EXCEPTION_NAME = "java/lang/Exception";
    static final String RUNTIME_EXCEPTION_NAME = "java/lang/RuntimeException";
    static final String THROWABLE_NAME = "java/lang/Throwable";
    static final String SUSPEND_EXECUTION_NAME = "co/paralleluniverse/fibers/SuspendExecution";
    static final String RUNTIME_SUSPEND_EXECUTION_NAME = "co/paralleluniverse/fibers/RuntimeSuspendExecution";
    static final String UNDECLARED_THROWABLE_NAME = "java/lang/reflect/UndeclaredThrowableException";
    static final String ANNOTATION_NAME = "co/paralleluniverse/fibers/Suspendable";
    static final String DONT_INSTRUMENT_ANNOTATION_NAME = "co/paralleluniverse/fibers/instrument/DontInstrument";
    static final String FIBER_CLASS_NAME = "co/paralleluniverse/fibers/Fiber";
    private static final String STRAND_NAME = "co/paralleluniverse/strands/Strand";
    static final String STACK_NAME = "co/paralleluniverse/fibers/Stack";
    private static final BlockingMethod[] BLOCKING_METHODS = new BlockingMethod[]{new BlockingMethod("java/lang/Thread", "sleep", new String[]{"(J)V", "(JI)V"}), new BlockingMethod("java/lang/Thread", "join", new String[]{"()V", "(J)V", "(JI)V"}), new BlockingMethod("java/lang/Object", "wait", new String[]{"()V", "(J)V", "(JI)V"})};
    static final String EXCEPTION_DESC = "Lco/paralleluniverse/fibers/SuspendExecution;";
    static final String ANNOTATION_DESC = "Lco/paralleluniverse/fibers/Suspendable;";
    static final String DONT_INSTRUMENT_ANNOTATION_DESC = "Lco/paralleluniverse/fibers/instrument/DontInstrument;";
    static final String ALREADY_INSTRUMENTED_DESC = Type.getDescriptor(Instrumented.class);
    private static final Set<String> yieldMethods = new HashSet<String>(Arrays.asList("park", "yield", "parkAndUnpark", "yieldAndUnpark", "parkAndSerialize"));

    static boolean isYieldMethod(String className, String methodName) {
        return FIBER_CLASS_NAME.equals(className) && yieldMethods.contains(methodName);
    }

    public static boolean isAllowedToBlock(String className, String methodName) {
        return STRAND_NAME.equals(className);
    }

    public static int blockingCallIdx(MethodInsnNode ins) {
        int n = BLOCKING_METHODS.length;
        for (int i = 0; i < n; ++i) {
            if (!BLOCKING_METHODS[i].match(ins)) continue;
            return i;
        }
        return -1;
    }

    private Classes() {
    }

    static class BlockingMethod {
        private final String owner;
        private final String name;
        private final String[] descs;

        private BlockingMethod(String owner, String name, String ... descs) {
            this.owner = owner;
            this.name = name;
            this.descs = descs;
        }

        public boolean match(MethodInsnNode min) {
            if (this.owner.equals(min.owner) && this.name.equals(min.name)) {
                for (String desc : this.descs) {
                    if (!desc.equals(min.desc)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

