/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.common.monitoring;

import co.paralleluniverse.common.monitoring.HistogramSnapshot;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Snapshot;
import org.HdrHistogram.Histogram;
import org.LatencyUtils.LatencyStats;

public class LatencyStatsReservoir
implements Reservoir {
    private final LatencyStats stats;
    private final Histogram runningTotals;
    private final Histogram intervalHistogram;

    public LatencyStatsReservoir(LatencyStats stats) {
        this.stats = stats;
        this.intervalHistogram = stats.getIntervalHistogram();
        this.runningTotals = new Histogram(this.intervalHistogram.getNumberOfSignificantValueDigits());
    }

    public int size() {
        return this.getSnapshot().size();
    }

    public void update(long value) {
        this.stats.recordLatency(value);
    }

    public Snapshot getSnapshot() {
        return new HistogramSnapshot(this.updateRunningTotals());
    }

    private synchronized Histogram updateRunningTotals() {
        this.stats.addIntervalHistogramTo(this.runningTotals);
        return this.runningTotals.copy();
    }
}

