/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy.example.pingpong;

import co.paralleluniverse.actors.ActorRef;
import co.paralleluniverse.actors.ActorRegistry;
import co.paralleluniverse.actors.BasicActor;
import co.paralleluniverse.actors.LocalActor;
import co.paralleluniverse.fibers.SuspendExecution;
import co.paralleluniverse.galaxy.example.pingpong.Message;
import co.paralleluniverse.strands.Strand;

public class Ping {
    private static final int nodeId = 1;

    public static void main(String[] args) throws Exception {
        System.setProperty("galaxy.nodeId", Integer.toString(1));
        System.setProperty("galaxy.port", Integer.toString(7051));
        System.setProperty("galaxy.slave_port", Integer.toString(8051));
        ActorRef ping = new BasicActor<Message, Void>(){

            protected Void doRun() throws InterruptedException, SuspendExecution {
                ActorRef pong;
                while ((pong = ActorRegistry.getActor((String)"pong")) == null) {
                    System.out.println("waiting for pong");
                    Strand.sleep((long)3000L);
                }
                System.out.println("pong is " + pong);
                for (int i = 0; i < 3; ++i) {
                    pong.send((Object)new Message(this.self(), Message.Type.PING));
                    Message msg = (Message)this.receive();
                    System.out.println("ping received " + (Object)((Object)msg.type));
                }
                pong.send((Object)new Message(null, Message.Type.FINISHED));
                return null;
            }
        }.spawn();
        LocalActor.join((ActorRef)ping);
        System.out.println("finished ping");
        System.exit(0);
    }
}

