/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy.example.pingpong;

import co.paralleluniverse.actors.ActorRef;
import co.paralleluniverse.actors.BasicActor;
import co.paralleluniverse.actors.LocalActor;
import co.paralleluniverse.fibers.SuspendExecution;
import co.paralleluniverse.galaxy.example.pingpong.Message;

public class Pong {
    private static final int nodeId = 2;

    public static void main(String[] args) throws Exception {
        System.setProperty("galaxy.nodeId", Integer.toString(2));
        System.setProperty("galaxy.port", Integer.toString(7052));
        System.setProperty("galaxy.slave_port", Integer.toString(8052));
        ActorRef pong = new BasicActor<Message, Void>(){

            /*
             * Enabled aggressive block sorting
             */
            protected Void doRun() throws InterruptedException, SuspendExecution {
                this.register("pong");
                while (true) {
                    Message msg = (Message)this.receive();
                    System.out.println("pong received " + (Object)((Object)msg.type));
                    switch (msg.type) {
                        case PING: {
                            msg.from.send((Object)new Message(this.self(), Message.Type.PONG));
                            break;
                        }
                        case FINISHED: {
                            return null;
                        }
                    }
                }
            }
        }.spawn();
        LocalActor.join((ActorRef)pong);
        System.out.println("finished pong");
        System.exit(0);
    }
}

