/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy.example.simplegenevent;

import co.paralleluniverse.actors.Actor;
import co.paralleluniverse.actors.ActorRef;
import co.paralleluniverse.actors.LocalActor;
import co.paralleluniverse.actors.behaviors.EventHandler;
import co.paralleluniverse.actors.behaviors.EventSource;
import co.paralleluniverse.actors.behaviors.EventSourceActor;
import co.paralleluniverse.actors.behaviors.Initializer;
import co.paralleluniverse.fibers.SuspendExecution;
import co.paralleluniverse.strands.channels.DelayedVal;
import java.util.concurrent.ExecutionException;

public class Server {
    private static final int nodeId = 2;

    public static void main(String[] args) throws ExecutionException, InterruptedException {
        System.setProperty("galaxy.nodeId", Integer.toString(2));
        System.setProperty("galaxy.port", Integer.toString(7052));
        System.setProperty("galaxy.slave_port", Integer.toString(8052));
        DelayedVal dv = new DelayedVal();
        EventSource ge = new EventSourceActor(new Initializer(){

            public void init() throws SuspendExecution {
                Actor.currentActor().register("myEventServer");
                final EventSource ge = (EventSource)LocalActor.self();
                try {
                    ge.addHandler((EventHandler)new EventHandler<String>(){

                        public void handleEvent(String event) {
                            System.out.println("Handling event: " + event);
                            ge.shutdown();
                        }
                    });
                }
                catch (InterruptedException ex) {
                    System.out.println("error " + ex);
                }
            }

            public void terminate(Throwable cause) throws SuspendExecution {
                System.out.println("server terminated");
            }
        }).spawn();
        LocalActor.join((ActorRef)ge);
        System.exit(0);
    }
}

