/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy.example.testing;

import co.paralleluniverse.actors.Actor;
import co.paralleluniverse.actors.ActorRef;
import co.paralleluniverse.actors.ActorRegistry;
import co.paralleluniverse.actors.BasicActor;
import co.paralleluniverse.actors.LocalActor;
import co.paralleluniverse.actors.MailboxConfig;
import co.paralleluniverse.actors.behaviors.AbstractServerHandler;
import co.paralleluniverse.actors.behaviors.EventHandler;
import co.paralleluniverse.actors.behaviors.EventSource;
import co.paralleluniverse.actors.behaviors.EventSourceActor;
import co.paralleluniverse.actors.behaviors.Initializer;
import co.paralleluniverse.actors.behaviors.Server;
import co.paralleluniverse.actors.behaviors.ServerActor;
import co.paralleluniverse.actors.behaviors.ServerHandler;
import co.paralleluniverse.common.util.Exceptions;
import co.paralleluniverse.concurrent.util.ThreadUtil;
import co.paralleluniverse.fibers.Fiber;
import co.paralleluniverse.fibers.SuspendExecution;
import co.paralleluniverse.galaxy.Grid;
import co.paralleluniverse.galaxy.Store;
import co.paralleluniverse.galaxy.StoreTransaction;
import co.paralleluniverse.galaxy.TimeoutException;
import co.paralleluniverse.strands.Strand;
import co.paralleluniverse.strands.channels.Channels;
import co.paralleluniverse.strands.channels.DelayedVal;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.LinkedList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;

public class PeerTKB {
    private final int i;

    public PeerTKB(String name, int i) throws InterruptedException, IOException {
        System.out.println("STARTING PEER " + i);
        URL peerXml = PeerTKB.class.getClassLoader().getResource("config/peer.xml");
        System.setProperty("galaxy.nodeId", Integer.toString(i));
        System.setProperty("galaxy.port", Integer.toString(7050 + i));
        System.setProperty("galaxy.slave_port", Integer.toString(8050 + i));
        System.setProperty("galaxy.multicast.address", "225.0.0.1");
        System.setProperty("galaxy.multicast.port", Integer.toString(7050));
        System.setProperty("co.paralleluniverse.galaxy.configFile", peerXml.getPath());
        System.setProperty("co.paralleluniverse.galaxy.autoGoOnline", "true");
        this.i = i;
    }

    public void run() throws ExecutionException, InterruptedException {
        switch (SCENARIO.testGenEvent) {
            case test: {
                byte[] get;
                StoreTransaction tx;
                Store store = Grid.getInstance().store();
                if (this.i == 1) {
                    tx = store.beginTransaction();
                    try {
                        long root = store.getRoot("root", tx);
                        byte[] buf = null;
                        store.set(root, buf, tx);
                        store.commit(tx);
                    }
                    catch (TimeoutException ex) {
                        throw new RuntimeException("set failed");
                    }
                    Thread.sleep(20000L);
                    break;
                }
                tx = store.beginTransaction();
                try {
                    long l = store.getRoot("root", tx);
                    get = store.get(l);
                    store.commit(tx);
                }
                catch (TimeoutException timeoutException) {
                    throw new RuntimeException("get failed");
                }
                System.out.println(get);
                break;
            }
            case testGenServer: {
                if (this.i == 1) {
                    this.spawnGenServer((ServerHandler<Message, Integer, Message>)new AbstractServerHandler<Message, Integer, Message>(){

                        public void init() throws SuspendExecution {
                            super.init();
                            ServerActor.currentServerActor().register("myServer");
                        }

                        public Integer handleCall(ActorRef<?> from, Object id, Message m) {
                            return m.a + m.b;
                        }
                    }).join();
                    break;
                }
                Integer get = (Integer)this.spawnActor((Actor)new BasicActor<Message, Integer>(new MailboxConfig(10, Channels.OverflowPolicy.THROW)){

                    protected Integer doRun() throws SuspendExecution, InterruptedException {
                        Server gs = (Server)ActorRegistry.getActor((String)"myServer");
                        return (Integer)gs.call((Object)new Message(3, 4));
                    }
                }).get();
                System.out.println("value is " + get);
                assert (get == 7);
                break;
            }
            case testGenEvent: {
                if (this.i == 1) {
                    final DelayedVal dv = new DelayedVal();
                    this.spawnGenEvent(new Initializer(){

                        public void init() throws SuspendExecution {
                            EventSourceActor.currentEventSourceActor().register("myEventServer");
                            try {
                                final EventSource ge = (EventSource)LocalActor.self();
                                ge.addHandler((EventHandler)new EventHandler<String>(){

                                    public void handleEvent(String event) {
                                        dv.set((Object)event);
                                        System.out.println("sout " + event);
                                        ge.shutdown();
                                    }
                                });
                            }
                            catch (InterruptedException ex) {
                                System.out.println(ex);
                            }
                        }

                        public void terminate(Throwable cause) throws SuspendExecution {
                            System.out.println("terminated");
                        }
                    });
                    String get = (String)dv.get();
                    System.out.println("got msg " + get);
                    assert (get.equals("hello world"));
                    break;
                }
                this.spawnActor((Actor)new BasicActor<Message, Void>(){

                    protected Void doRun() throws SuspendExecution, InterruptedException {
                        EventSource ge = (EventSource)ActorRegistry.getActor((String)"myEventServer");
                        ge.notify((Object)"hello world");
                        return null;
                    }
                }).join();
                break;
            }
            case testMultiGetActor: {
                if (this.i == 1) {
                    this.spawnGenEvent(new Initializer(){
                        AtomicInteger ai = new AtomicInteger();

                        public void init() throws SuspendExecution {
                            Actor.currentActor().register("myEventServer");
                            try {
                                EventSource ge = (EventSource)LocalActor.self();
                                ge.addHandler((EventHandler)new EventHandler<String>(){

                                    public void handleEvent(String event) {
                                        System.out.println("msg no " + ai.incrementAndGet() + ": " + event);
                                    }
                                });
                            }
                            catch (InterruptedException ex) {
                                System.out.println(ex);
                            }
                        }

                        public void terminate(Throwable cause) throws SuspendExecution {
                            System.out.println("terminated");
                        }
                    }).join();
                    break;
                }
                LinkedList<BasicActor> queue = new LinkedList<BasicActor>();
                for (int j = 0; j < 1000; ++j) {
                    BasicActor basicActor = this.spawnActor((Actor)new BasicActor<Message, Void>("actor-" + j){

                        protected Void doRun() throws SuspendExecution, InterruptedException {
                            try {
                                EventSource ge = (EventSource)ActorRegistry.getActor((String)"myEventServer");
                                ge.notify((Object)("hwf " + this.getName()));
                            }
                            catch (Exception e) {
                                System.out.println("error in " + this.getName());
                                throw e;
                            }
                            return null;
                        }
                    });
                    queue.add(basicActor);
                }
                for (Actor actor : queue) {
                    actor.join();
                }
                Thread.sleep(500L);
                break;
            }
            case testOrdering: {
                if (this.i == 1) {
                    this.spawnGenEvent(new Initializer(){
                        AtomicInteger ai = new AtomicInteger();

                        public void init() throws SuspendExecution {
                            EventSourceActor.currentEventSourceActor().register("myEventServer");
                            try {
                                EventSourceActor ge = EventSourceActor.currentEventSourceActor();
                                ge.ref().addHandler((EventHandler)new EventHandler<String>(){

                                    public void handleEvent(String event) {
                                        System.out.println("msg no " + ai.incrementAndGet() + ": " + event);
                                    }
                                });
                            }
                            catch (InterruptedException ex) {
                                System.out.println(ex);
                            }
                        }

                        public void terminate(Throwable cause) throws SuspendExecution {
                            System.out.println("terminated");
                        }
                    }).join();
                    break;
                }
                LinkedList<BasicActor> queue = new LinkedList();
                for (int j = 0; j < 1; ++j) {
                    BasicActor basicActor = this.spawnActor((Actor)new BasicActor<Message, Void>("actor-" + j){

                        protected Void doRun() throws SuspendExecution, InterruptedException {
                            try {
                                EventSource ge = (EventSource)ActorRegistry.getActor((String)"myEventServer");
                                for (int k = 0; k < 3000; ++k) {
                                    ge.notify((Object)("hw " + k + " f" + this.getName()));
                                }
                            }
                            catch (Exception e) {
                                System.out.println("error in " + this.getName());
                                throw e;
                            }
                            return null;
                        }
                    });
                    queue.add(basicActor);
                }
                for (Actor actor : queue) {
                    actor.join();
                }
                Thread.sleep(5000L);
                break;
            }
        }
        System.out.println("finished");
        System.exit(0);
        while (true) {
            System.out.println("==================");
            ThreadUtil.dumpThreads();
            Thread.sleep(5000L);
        }
    }

    private ServerActor<Message, Integer, Message> spawnGenServer(ServerHandler<Message, Integer, Message> server) {
        return this.spawnActor(new ServerActor(server));
    }

    private EventSourceActor<String> spawnGenEvent(Initializer initializer) {
        return this.spawnActor(new EventSourceActor(initializer));
    }

    private <T extends Actor<Message, V>, Message, V> T spawnActor(T actor) {
        Fiber fiber = new Fiber(actor);
        fiber.setUncaughtExceptionHandler(new Strand.UncaughtExceptionHandler(){

            public void uncaughtException(Strand s, Throwable e) {
                e.printStackTrace();
                throw Exceptions.rethrow((Throwable)e);
            }
        });
        fiber.start();
        return actor;
    }

    public static class Message
    implements Serializable {
        public final int a;
        public final int b;

        public Message(int a, int b) {
            this.a = a;
            this.b = b;
        }

        public int hashCode() {
            int hash = 3;
            hash = 43 * hash + this.a;
            hash = 43 * hash + this.b;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Message other = (Message)obj;
            if (this.a != other.a) {
                return false;
            }
            return this.b == other.b;
        }
    }

    static class RepliableMessage<T>
    implements Serializable {
        T data;
        ActorRef sender;

        public RepliableMessage(T data, ActorRef sender) {
            this.data = data;
            this.sender = sender;
        }
    }

    static enum SCENARIO {
        pingPong,
        testGenServer,
        testGenEvent,
        testMultiGetActor,
        testOrdering,
        test;

    }
}

