/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.galaxy.quasar;

import co.paralleluniverse.common.io.Streamable;
import co.paralleluniverse.fibers.SuspendExecution;
import co.paralleluniverse.fibers.futures.AsyncListenableFuture;
import co.paralleluniverse.galaxy.MessageListener;
import co.paralleluniverse.galaxy.TimeoutException;
import co.paralleluniverse.galaxy.quasar.Messenger;
import co.paralleluniverse.strands.Strand;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.ExecutionException;

public class MessengerImpl
implements Messenger {
    private final co.paralleluniverse.galaxy.Messenger messenger;

    public MessengerImpl(co.paralleluniverse.galaxy.Messenger messenger) {
        this.messenger = messenger;
    }

    @Override
    public void addMessageListener(long topic, MessageListener listener) {
        this.messenger.addMessageListener(topic, listener);
    }

    @Override
    public void addMessageListener(String topic, MessageListener listener) {
        this.messenger.addMessageListener(topic, listener);
    }

    @Override
    public void removeMessageListener(long topic, MessageListener listener) {
        this.messenger.removeMessageListener(topic, listener);
    }

    @Override
    public void removeMessageListener(String topic, MessageListener listener) {
        this.messenger.removeMessageListener(topic, listener);
    }

    @Override
    public void send(short node, String topic, byte[] data) {
        this.messenger.send(node, topic, data);
    }

    @Override
    public void send(short node, long topic, Streamable data) {
        this.messenger.send(node, topic, data);
    }

    @Override
    public void send(short node, String topic, Streamable data) {
        this.messenger.send(node, topic, data);
    }

    @Override
    public void send(short node, long topic, byte[] data) {
        this.messenger.send(node, topic, data);
    }

    @Override
    public void sendToOwnerOf(long ref, long topic, byte[] data) throws TimeoutException, SuspendExecution {
        this.result(this.messenger.sendToOwnerOfAsync(ref, topic, data));
    }

    @Override
    public void sendToOwnerOf(long ref, String topic, byte[] data) throws TimeoutException, SuspendExecution {
        this.result(this.messenger.sendToOwnerOfAsync(ref, topic, data));
    }

    @Override
    public void sendToOwnerOf(long ref, long topic, Streamable data) throws TimeoutException, SuspendExecution {
        this.result(this.messenger.sendToOwnerOfAsync(ref, topic, data));
    }

    @Override
    public void sendToOwnerOf(long ref, String topic, Streamable data) throws TimeoutException, SuspendExecution {
        this.result(this.messenger.sendToOwnerOfAsync(ref, topic, data));
    }

    private <V> V result(ListenableFuture<V> future) throws TimeoutException, SuspendExecution {
        try {
            return (V)AsyncListenableFuture.get(future);
        }
        catch (ExecutionException e) {
            Throwable ex = e.getCause();
            if (ex instanceof TimeoutException) {
                throw (TimeoutException)ex;
            }
            Throwables.propagateIfPossible((Throwable)ex);
            throw Throwables.propagate((Throwable)ex);
        }
        catch (InterruptedException ex) {
            Strand.currentStrand().interrupt();
            return null;
        }
    }
}

