/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.remote.galaxy;

import co.paralleluniverse.actors.ActorRef;
import co.paralleluniverse.actors.GlobalRegistry;
import co.paralleluniverse.actors.LocalActor;
import co.paralleluniverse.fibers.SuspendExecution;
import co.paralleluniverse.galaxy.Cache;
import co.paralleluniverse.galaxy.CacheListener;
import co.paralleluniverse.galaxy.Grid;
import co.paralleluniverse.galaxy.StoreTransaction;
import co.paralleluniverse.galaxy.TimeoutException;
import co.paralleluniverse.galaxy.quasar.Store;
import co.paralleluniverse.io.serialization.Serialization;
import co.paralleluniverse.remote.galaxy.GlxRemoteChannel;
import co.paralleluniverse.remote.galaxy.RemoteChannelReceiver;
import co.paralleluniverse.strands.concurrent.ReentrantLock;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlxGlobalRegistry
implements GlobalRegistry {
    private static final ConcurrentHashMap<String, ActorRef> rootCache = new ConcurrentHashMap();
    private static final Logger LOG = LoggerFactory.getLogger(GlxGlobalRegistry.class);
    private static final Serialization ser = Serialization.getInstance();
    private static final ReentrantLock serlock = new ReentrantLock();
    private final co.paralleluniverse.galaxy.quasar.Grid grid;

    public GlxGlobalRegistry() {
        try {
            this.grid = new co.paralleluniverse.galaxy.quasar.Grid(Grid.getInstance());
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Object register(ActorRef<?> actor) throws SuspendExecution {
        String rootName = actor.getName();
        LOG.info("Registering actor {} at root {}", actor, (Object)rootName);
        Store store = this.grid.store();
        StoreTransaction txn = store.beginTransaction();
        serlock.lock();
        try {
            long root = store.getRoot(rootName, txn);
            store.getx(root, txn);
            store.set(root, ser.write(actor), txn);
            LOG.debug("commit Registering actor {} at rootId  {}", actor, (Object)root);
            store.commit(txn);
            RemoteChannelReceiver.getReceiver(LocalActor.getMailbox(actor), true).handleRefMessage(new GlxRemoteChannel.RefMessage(true, this.grid.cluster().getMyNodeId()));
            Long l = root;
            return l;
        }
        catch (TimeoutException e) {
            try {
                LOG.error("Registering actor {} at root {} failed due to timeout", actor, (Object)rootName);
                store.rollback(txn);
                store.abort(txn);
                throw new RuntimeException("Actor registration failed");
            }
            catch (InterruptedException e2) {
                throw new RuntimeException(e2);
            }
        }
        finally {
            serlock.unlock();
        }
    }

    public void unregister(ActorRef<?> actor) throws SuspendExecution {
        String rootName = actor.getName();
        LOG.info("Uregistering {}", (Object)rootName);
        Store store = this.grid.store();
        StoreTransaction txn = store.beginTransaction();
        try {
            try {
                long root = store.getRoot(rootName, txn);
                store.set(root, (byte[])null, txn);
                store.commit(txn);
                RemoteChannelReceiver.getReceiver(LocalActor.getMailbox(actor), true).handleRefMessage(new GlxRemoteChannel.RefMessage(false, this.grid.cluster().getMyNodeId()));
            }
            catch (TimeoutException e) {
                LOG.error("Unregistering {} failed due to timeout", (Object)rootName);
                store.rollback(txn);
                store.abort(txn);
                throw new RuntimeException("Actor unregistration failed");
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <Message> ActorRef<Message> getActor(String name) throws SuspendExecution {
        String rootName = name;
        ActorRef cacheValue = rootCache.get(rootName);
        if (cacheValue != null) {
            return cacheValue;
        }
        serlock.lock();
        try {
            cacheValue = rootCache.get(rootName);
            if (cacheValue != null) {
                ActorRef actorRef = cacheValue;
                return actorRef;
            }
            ActorRef<Message> actorRef = this.getRootFromStoreAndUpdateCache(rootName);
            return actorRef;
        }
        finally {
            serlock.unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <Message> ActorRef<Message> getRootFromStoreAndUpdateCache(final String rootName) throws SuspendExecution, RuntimeException {
        final Store store = this.grid.store();
        StoreTransaction txn = store.beginTransaction();
        try {
            boolean error = false;
            try {
                ActorRef actor;
                long root = store.getRoot(rootName, txn);
                byte[] buf = store.get(root);
                if (buf == null) {
                    ActorRef<Message> actorRef = null;
                    return actorRef;
                }
                if (buf.length == 0) {
                    ActorRef<Message> actorRef = null;
                    return actorRef;
                }
                try {
                    actor = (ActorRef)ser.read(buf);
                }
                catch (Exception e) {
                    LOG.info("Deserializing actor at root " + rootName + " has failed with exception", (Throwable)e);
                    ActorRef<Message> actorRef = null;
                    if (error) return actorRef;
                    store.commit(txn);
                    return actorRef;
                }
                store.setListener(root, new CacheListener(){

                    public void invalidated(Cache cache, long id) {
                        this.evicted(cache, id);
                    }

                    public void received(Cache cache, long id, long version, ByteBuffer data) {
                        this.evicted(cache, id);
                    }

                    public void evicted(Cache cache, long id) {
                        rootCache.remove(rootName);
                        store.setListener(id, null);
                    }
                });
                rootCache.put(rootName, actor);
                ActorRef actorRef = actor;
                return actorRef;
            }
            catch (TimeoutException e) {
                error = true;
                LOG.error("Getting actor {} failed due to timeout", (Object)rootName);
                store.rollback(txn);
                store.abort(txn);
                throw new RuntimeException("Actor discovery failed");
            }
            finally {
                if (!error) {
                    store.commit(txn);
                }
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

