/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.remote.galaxy;

import co.paralleluniverse.actors.ActorRef;
import co.paralleluniverse.actors.LifecycleListener;
import co.paralleluniverse.actors.LifecycleListenerProxy;
import co.paralleluniverse.actors.RemoteActorRef;
import co.paralleluniverse.galaxy.Grid;
import co.paralleluniverse.galaxy.cluster.NodeChangeListener;
import co.paralleluniverse.remote.galaxy.GlxRemoteActor;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlxLifecycleListenerProxy
extends LifecycleListenerProxy {
    private static final Logger LOG = LoggerFactory.getLogger(GlxLifecycleListenerProxy.class);
    private final co.paralleluniverse.galaxy.quasar.Grid grid;
    private static final Set<RegistryRecord> listenerRegistry = Collections.newSetFromMap(new ConcurrentHashMap());

    public GlxLifecycleListenerProxy() {
        try {
            this.grid = new co.paralleluniverse.galaxy.quasar.Grid(Grid.getInstance());
            this.grid.cluster().addNodeChangeListener(new NodeChangeListener(){

                public void nodeAdded(short id) {
                }

                public void nodeSwitched(short id) {
                }

                public void nodeRemoved(short id) {
                    Iterator it = listenerRegistry.iterator();
                    while (it.hasNext()) {
                        RegistryRecord registryRecord = (RegistryRecord)it.next();
                        if (registryRecord.getOwnerNodeId() != id) continue;
                        registryRecord.listener.dead((ActorRef)registryRecord.actor, new Throwable("cluster node removed"));
                        it.remove();
                    }
                }
            });
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void addLifecycleListener(RemoteActorRef actor, LifecycleListener listener) {
        GlxRemoteActor glxActor = (GlxRemoteActor)actor;
        short nodeId = glxActor.getOwnerNodeId();
        if (!this.grid.cluster().getNodes().contains(nodeId)) {
            listener.dead((ActorRef)actor, null);
            return;
        }
        super.addLifecycleListener(actor, listener);
        listenerRegistry.add(new RegistryRecord(listener, glxActor));
    }

    public void removeLifecycleListener(RemoteActorRef actor, LifecycleListener listener) {
        super.removeLifecycleListener(actor, listener);
        listenerRegistry.remove(new RegistryRecord(listener, (GlxRemoteActor)actor));
    }

    public void removeLifecycleListeners(RemoteActorRef actor, ActorRef observer) {
        super.removeLifecycleListeners(actor, observer);
        Iterator<RegistryRecord> it = listenerRegistry.iterator();
        while (it.hasNext()) {
            RegistryRecord registryRecord = it.next();
            if (!registryRecord.actor.equals(actor)) continue;
            it.remove();
        }
    }

    class RegistryRecord {
        final LifecycleListener listener;
        final GlxRemoteActor actor;

        public RegistryRecord(LifecycleListener listener, GlxRemoteActor actor) {
            this.listener = listener;
            this.actor = actor;
        }

        short getOwnerNodeId() {
            return this.actor.getOwnerNodeId();
        }
    }
}

