/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.remote.galaxy;

import co.paralleluniverse.actors.ActorRef;
import co.paralleluniverse.actors.ActorRefImpl;
import co.paralleluniverse.actors.LocalActor;
import co.paralleluniverse.actors.RemoteActorRef;
import co.paralleluniverse.common.util.Exceptions;
import co.paralleluniverse.fibers.DefaultFiberScheduler;
import co.paralleluniverse.fibers.Fiber;
import co.paralleluniverse.fibers.SuspendExecution;
import co.paralleluniverse.remote.galaxy.GlxRemoteChannel;
import co.paralleluniverse.remote.galaxy.RemoteChannelReceiver;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlxRemoteActor<Message>
extends RemoteActorRef<Message> {
    private static final Logger LOG = LoggerFactory.getLogger(GlxRemoteActor.class);

    public GlxRemoteActor(ActorRef<Message> actor, Object globalId) {
        super(actor);
        RemoteChannelReceiver<Object> receiver = RemoteChannelReceiver.getReceiver(LocalActor.getMailbox(actor), globalId != null);
        receiver.setFilter(new RemoteChannelReceiver.MessageFilter<Object>(){

            @Override
            public boolean shouldForwardMessage(Object msg) {
                if (msg instanceof RemoteActorRef.RemoteActorAdminMessage) {
                    GlxRemoteActor.this.handleAdminMessage((RemoteActorRef.RemoteActorAdminMessage)msg);
                    return false;
                }
                return true;
            }
        });
    }

    short getOwnerNodeId() {
        return ((GlxRemoteChannel)this.getMailbox()).getOwnerNodeId();
    }

    protected void internalSend(Object message) throws SuspendExecution {
        ((GlxRemoteChannel)this.mailbox()).send(message);
    }

    protected void internalSendNonSuspendable(final Object message) {
        try {
            new Fiber<Void>(DefaultFiberScheduler.getInstance()){

                protected Void run() throws SuspendExecution, InterruptedException {
                    GlxRemoteActor.this.internalSend(message);
                    return null;
                }
            }.start().get();
        }
        catch (ExecutionException e) {
            throw Exceptions.rethrow((Throwable)e.getCause());
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public int hashCode() {
        int hash = 5;
        hash = 43 * hash + Objects.hashCode(this.mailbox());
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlxRemoteActor)) {
            return false;
        }
        GlxRemoteActor other = (GlxRemoteActor)((Object)obj);
        return Objects.equals(this.mailbox(), other.mailbox());
    }

    static Class getActorLifecycleListenerClass() {
        return ActorRefImpl.ActorLifecycleListener.class;
    }
}

