/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.remote.galaxy;

import co.paralleluniverse.common.io.Streamable;
import co.paralleluniverse.fibers.FiberUtil;
import co.paralleluniverse.fibers.SuspendExecution;
import co.paralleluniverse.galaxy.Cluster;
import co.paralleluniverse.galaxy.Grid;
import co.paralleluniverse.galaxy.TimeoutException;
import co.paralleluniverse.galaxy.quasar.Messenger;
import co.paralleluniverse.io.serialization.Serialization;
import co.paralleluniverse.remote.RemoteException;
import co.paralleluniverse.remote.galaxy.RemoteChannelReceiver;
import co.paralleluniverse.strands.SuspendableRunnable;
import co.paralleluniverse.strands.Timeout;
import co.paralleluniverse.strands.channels.SendPort;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlxRemoteChannel<Message>
implements SendPort<Message>,
Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(GlxRemoteChannel.class);
    private static final co.paralleluniverse.galaxy.quasar.Grid grid;
    private static final ExecutorService sendThreadPool;
    private final Object topic;
    private final long address;
    private final boolean global;
    private final short ownerNodeId;

    static Messenger getMessenger() {
        return grid.messenger();
    }

    static Cluster getCluster() {
        return grid.cluster();
    }

    public GlxRemoteChannel(SendPort<Message> channel, Object globalId) {
        RemoteChannelReceiver<Message> receiver = RemoteChannelReceiver.getReceiver(channel, globalId != null);
        this.topic = receiver.getTopic();
        this.ownerNodeId = GlxRemoteChannel.getCluster().getMyNodeId();
        if (globalId != null) {
            this.address = (Long)globalId;
            this.global = true;
        } else {
            this.address = this.ownerNodeId;
            this.global = false;
        }
    }

    public short getOwnerNodeId() {
        return this.ownerNodeId;
    }

    public void send(Message message) throws SuspendExecution {
        GlxRemoteChannel.submitSend(message, this.global, this.address, this.topic);
    }

    public boolean send(Message message, long timeout, TimeUnit unit) throws SuspendExecution, InterruptedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean send(Message message, Timeout timeout) throws SuspendExecution, InterruptedException {
        return this.send(message, timeout.nanosLeft(), TimeUnit.NANOSECONDS);
    }

    public boolean trySend(final Message message) {
        try {
            FiberUtil.runInFiberRuntime((SuspendableRunnable)new SuspendableRunnable(){

                public void run() throws SuspendExecution, InterruptedException {
                    GlxRemoteChannel.this.send(message);
                }
            });
            return true;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        try {
            FiberUtil.runInFiberRuntime((SuspendableRunnable)new SuspendableRunnable(){

                public void run() throws SuspendExecution, InterruptedException {
                    GlxRemoteChannel.this.send(new CloseMessage());
                }
            });
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public int hashCode() {
        int hash = 5;
        hash = 43 * hash + Objects.hashCode(this.topic);
        hash = 43 * hash + (int)(this.address ^ this.address >>> 32);
        hash = 43 * hash + (this.global ? 1 : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlxRemoteChannel)) {
            return false;
        }
        GlxRemoteChannel other = (GlxRemoteChannel)obj;
        if (!Objects.equals(this.topic, other.topic)) {
            return false;
        }
        if (this.address != other.address) {
            return false;
        }
        return this.global == other.global;
    }

    protected Object readResolve() throws ObjectStreamException, SuspendExecution {
        new RCPhantomReference(this).register();
        return this;
    }

    private static void registerRemoteRef(short myNodeId, boolean global, long address, Object topic) throws SuspendExecution {
        GlxRemoteChannel.submitSend(new RefMessage(true, myNodeId), global, address, topic);
    }

    private static void unregisterRemoteRef(short myNodeId, boolean global, long address, Object topic) throws SuspendExecution {
        GlxRemoteChannel.submitSend(new RefMessage(false, myNodeId), global, address, topic);
    }

    private static void submitSend(final Object message, final boolean global, final long address, final Object topic) throws SuspendExecution {
        LOG.debug("sending: " + message);
        sendThreadPool.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    GlxRemoteChannel.staticSend(message, global, address, topic);
                    LOG.debug("sent {}", message);
                }
                catch (SuspendExecution e) {
                    throw new AssertionError((Object)e);
                }
            }
        });
    }

    private static void staticSend(Object message, boolean global, long address, Object topic) throws SuspendExecution {
        try {
            if (global) {
                long ref = address;
                if (message instanceof Streamable) {
                    if (topic instanceof String) {
                        GlxRemoteChannel.getMessenger().sendToOwnerOf(ref, (String)topic, (Streamable)message);
                    } else {
                        GlxRemoteChannel.getMessenger().sendToOwnerOf(ref, (long)((Long)topic), (Streamable)message);
                    }
                } else {
                    byte[] buf = Serialization.getInstance().write(message);
                    if (topic instanceof String) {
                        GlxRemoteChannel.getMessenger().sendToOwnerOf(ref, (String)topic, buf);
                    } else {
                        GlxRemoteChannel.getMessenger().sendToOwnerOf(ref, (long)((Long)topic), buf);
                    }
                }
            } else {
                short node = (short)address;
                if (message instanceof Streamable) {
                    if (topic instanceof String) {
                        GlxRemoteChannel.getMessenger().send(node, (String)topic, (Streamable)message);
                    } else {
                        GlxRemoteChannel.getMessenger().send(node, (long)((Long)topic), (Streamable)message);
                    }
                } else {
                    byte[] buf = Serialization.getInstance().write(message);
                    if (topic instanceof String) {
                        GlxRemoteChannel.getMessenger().send(node, (String)topic, buf);
                    } else {
                        GlxRemoteChannel.getMessenger().send(node, (long)((Long)topic), buf);
                    }
                }
            }
        }
        catch (TimeoutException e) {
            throw new RemoteException((Throwable)e);
        }
    }

    private short getNodeId() {
        return GlxRemoteChannel.getCluster().getMyNodeId();
    }

    static {
        sendThreadPool = Executors.newSingleThreadExecutor();
        try {
            grid = new co.paralleluniverse.galaxy.quasar.Grid(Grid.getInstance());
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
    }

    static class RCPhantomReference
    extends PhantomReference<GlxRemoteChannel> {
        private static final Set<RCPhantomReference> rcs = Collections.newSetFromMap(new ConcurrentHashMap());
        private static final ReferenceQueue<GlxRemoteChannel> q = new ReferenceQueue();
        final short myNodeId;
        public final boolean globalCopy;
        public final long addressCopy;
        public final Object topicCopy;

        public RCPhantomReference(GlxRemoteChannel referent) {
            super(referent, q);
            this.topicCopy = referent.topic;
            this.addressCopy = referent.address;
            this.globalCopy = referent.global;
            this.myNodeId = referent.getNodeId();
        }

        public void unregister() throws SuspendExecution {
            GlxRemoteChannel.unregisterRemoteRef(this.myNodeId, this.globalCopy, this.addressCopy, this.topicCopy);
            rcs.remove(this);
        }

        public void register() throws SuspendExecution {
            rcs.add(this);
            GlxRemoteChannel.registerRemoteRef(this.myNodeId, this.globalCopy, this.addressCopy, this.topicCopy);
        }

        static {
            Thread collector = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        while (!Thread.interrupted()) {
                            try {
                                final RCPhantomReference ref = (RCPhantomReference)q.remove();
                                FiberUtil.runInFiber((SuspendableRunnable)new SuspendableRunnable(){

                                    public void run() throws SuspendExecution, InterruptedException {
                                        ref.unregister();
                                    }
                                });
                            }
                            catch (ExecutionException e) {
                                LOG.error(e.toString());
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        LOG.info(this.toString() + " has been interrupted");
                    }
                }
            }, "remote-references-collector");
            collector.setDaemon(true);
            collector.start();
        }
    }

    static class RefMessage
    implements Serializable {
        final boolean add;
        final short nodeId;

        public boolean isAdd() {
            return this.add;
        }

        public short getNodeId() {
            return this.nodeId;
        }

        public RefMessage(boolean add, short nodeId) {
            this.add = add;
            this.nodeId = nodeId;
        }

        public String toString() {
            return "RefMessage{add=" + this.add + ", nodeId=" + this.nodeId + '}';
        }
    }

    static class CloseMessage
    implements Serializable {
        CloseMessage() {
        }
    }
}

