/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.remote.galaxy;

import co.paralleluniverse.fibers.SuspendExecution;
import co.paralleluniverse.galaxy.Grid;
import co.paralleluniverse.galaxy.MessageListener;
import co.paralleluniverse.galaxy.cluster.NodeChangeListener;
import co.paralleluniverse.galaxy.quasar.Messenger;
import co.paralleluniverse.io.serialization.Serialization;
import co.paralleluniverse.remote.galaxy.GlxRemoteChannel;
import co.paralleluniverse.strands.channels.QueueChannel;
import co.paralleluniverse.strands.channels.SendPort;
import java.lang.ref.ReferenceQueue;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import jsr166e.ConcurrentHashMapV8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteChannelReceiver<Message>
implements MessageListener {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteChannelReceiver.class);
    private static final ConcurrentMap<SendPort<?>, RemoteChannelReceiver<?>> receivers = new ConcurrentHashMapV8();
    private static final ReferenceQueue<QueueChannel> refQueue = new ReferenceQueue();
    private static final AtomicLong topicGen = new AtomicLong(1000L);
    private final SendPort<Message> channel;
    private final Object topic;
    private volatile MessageFilter<Message> filter;
    private final Map<Short, Integer> references = new ConcurrentHashMap<Short, Integer>();

    public static <Message> RemoteChannelReceiver<Message> getReceiver(SendPort<Message> channel, boolean global) {
        RemoteChannelReceiver<Message> receiver = (RemoteChannelReceiver<Message>)receivers.get(channel);
        if (receiver == null) {
            receiver = RemoteChannelReceiver.createrReceiver(channel, global);
            RemoteChannelReceiver<Message> tmp = receivers.putIfAbsent(channel, receiver);
            if (tmp == null) {
                super.subscribe();
            } else {
                receiver = tmp;
            }
        }
        return receiver;
    }

    private static <Message> RemoteChannelReceiver<Message> createrReceiver(SendPort<Message> channel, boolean global) {
        return new RemoteChannelReceiver<Message>(channel, global);
    }

    void shutdown() {
        LOG.debug("shutdown of receiver due to zero references" + this);
        this.unsubscribe();
        receivers.remove(this.channel);
    }

    private RemoteChannelReceiver(SendPort<Message> channel, boolean isGlobal) {
        this.channel = channel;
        this.topic = isGlobal ? UUID.randomUUID().toString() : Long.valueOf(topicGen.incrementAndGet());
        try {
            new co.paralleluniverse.galaxy.quasar.Grid(Grid.getInstance()).cluster().addNodeChangeListener(new NodeChangeListener(){

                public void nodeAdded(short id) {
                }

                public void nodeSwitched(short id) {
                }

                public void nodeRemoved(short id) {
                    LOG.debug("decrease RefCount for {} from node {}", (Object)this, (Object)id);
                    RemoteChannelReceiver.this.references.remove(id);
                    if (RemoteChannelReceiver.this.references.isEmpty()) {
                        RemoteChannelReceiver.this.shutdown();
                    }
                }
            });
        }
        catch (InterruptedException ex) {
            LOG.error(ex.toString());
        }
    }

    public void setFilter(MessageFilter<Message> filter) {
        this.filter = filter;
    }

    public void messageReceived(short fromNode, byte[] message) {
        Object m1 = Serialization.getInstance().read(message);
        LOG.debug("Received: " + m1);
        if (m1 instanceof GlxRemoteChannel.CloseMessage) {
            this.channel.close();
            this.unsubscribe();
            return;
        }
        if (m1 instanceof GlxRemoteChannel.RefMessage) {
            this.handleRefMessage((GlxRemoteChannel.RefMessage)m1);
            return;
        }
        Object m = m1;
        if (this.filter == null || this.filter.shouldForwardMessage(m)) {
            try {
                this.channel.send(m);
            }
            catch (SuspendExecution e) {
                throw new AssertionError((Object)e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void subscribe() {
        Messenger messenger = GlxRemoteChannel.getMessenger();
        if (this.topic instanceof String) {
            messenger.addMessageListener((String)this.topic, (MessageListener)this);
        } else {
            messenger.addMessageListener((Long)this.topic, (MessageListener)this);
        }
    }

    private void unsubscribe() {
        Messenger messenger = GlxRemoteChannel.getMessenger();
        if (this.topic instanceof String) {
            messenger.removeMessageListener((String)this.topic, (MessageListener)this);
        } else {
            messenger.removeMessageListener((Long)this.topic, (MessageListener)this);
        }
    }

    public Object getTopic() {
        return this.topic;
    }

    void handleRefMessage(GlxRemoteChannel.RefMessage msg) throws RuntimeException {
        LOG.debug("handling: " + msg);
        if (msg.isAdd()) {
            Integer refCount = this.references.get(msg.getNodeId());
            if (refCount == null) {
                this.references.put(msg.getNodeId(), 1);
            } else {
                this.references.put(msg.getNodeId(), refCount + 1);
            }
        } else {
            Integer refCount = this.references.get(msg.getNodeId());
            if (refCount == null) {
                throw new RuntimeException("decrease reference counter message received for unknown cluster node");
            }
            if ((refCount = Integer.valueOf(refCount - 1)) > 0) {
                this.references.put(msg.getNodeId(), refCount);
            } else {
                this.references.remove(msg.getNodeId());
                if (this.references.isEmpty()) {
                    this.shutdown();
                }
            }
        }
    }

    public static interface MessageFilter<Message> {
        public boolean shouldForwardMessage(Message var1);
    }
}

