/*
 * Decompiled with CFR 0.152.
 */
package com.abercap.mediainfo.api;

import com.abercap.mediainfo.api.MediaInfoLibrary;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaInfo
implements Closeable {
    private Pointer handle = MediaInfoLibrary.INSTANCE.New();

    public synchronized boolean open(File file) {
        return file.isFile() && MediaInfoLibrary.INSTANCE.Open(this.handle, new WString(file.getAbsolutePath())) > 0;
    }

    public synchronized String inform() {
        return MediaInfoLibrary.INSTANCE.Inform(this.handle).toString();
    }

    public String option(String option) {
        return this.option(option, "");
    }

    public synchronized String option(String option, String value) {
        return MediaInfoLibrary.INSTANCE.Option(this.handle, new WString(option), new WString(value)).toString();
    }

    public String get(StreamKind streamKind, int streamNumber, String parameter) {
        return this.get(streamKind, streamNumber, parameter, InfoKind.Text, InfoKind.Name);
    }

    public String get(StreamKind streamKind, int streamNumber, String parameter, InfoKind infoKind) {
        return this.get(streamKind, streamNumber, parameter, infoKind, InfoKind.Name);
    }

    public synchronized String get(StreamKind streamKind, int streamNumber, String parameter, InfoKind infoKind, InfoKind searchKind) {
        return MediaInfoLibrary.INSTANCE.Get(this.handle, streamKind.ordinal(), streamNumber, new WString(parameter), infoKind.ordinal(), searchKind.ordinal()).toString();
    }

    public String get(StreamKind streamKind, int streamNumber, int parameterIndex) {
        return this.get(streamKind, streamNumber, parameterIndex, InfoKind.Text);
    }

    public synchronized String get(StreamKind streamKind, int streamNumber, int parameterIndex, InfoKind infoKind) {
        return MediaInfoLibrary.INSTANCE.GetI(this.handle, streamKind.ordinal(), streamNumber, parameterIndex, infoKind.ordinal()).toString();
    }

    public synchronized int streamCount(StreamKind streamKind) {
        return MediaInfoLibrary.INSTANCE.Count_Get(this.handle, streamKind.ordinal(), -1);
    }

    public synchronized int parameterCount(StreamKind streamKind, int streamNumber) {
        return MediaInfoLibrary.INSTANCE.Count_Get(this.handle, streamKind.ordinal(), streamNumber);
    }

    public Map<StreamKind, List<Map<String, String>>> snapshot() {
        EnumMap<StreamKind, List<Map<String, String>>> mediaInfo = new EnumMap<StreamKind, List<Map<String, String>>>(StreamKind.class);
        for (StreamKind streamKind : StreamKind.values()) {
            int streamCount = this.streamCount(streamKind);
            if (streamCount <= 0) continue;
            ArrayList<Map<String, String>> streamInfoList = new ArrayList<Map<String, String>>(streamCount);
            for (int i = 0; i < streamCount; ++i) {
                streamInfoList.add(this.snapshot(streamKind, i));
            }
            mediaInfo.put(streamKind, streamInfoList);
        }
        return mediaInfo;
    }

    public Map<String, String> snapshot(StreamKind streamKind, int streamNumber) {
        LinkedHashMap<String, String> streamInfo = new LinkedHashMap<String, String>();
        int count = this.parameterCount(streamKind, streamNumber);
        for (int i = 0; i < count; ++i) {
            String value = this.get(streamKind, streamNumber, i, InfoKind.Text);
            if (value.length() <= 0) continue;
            streamInfo.put(this.get(streamKind, streamNumber, i, InfoKind.Name), value);
        }
        return streamInfo;
    }

    @Override
    public synchronized void close() {
        MediaInfoLibrary.INSTANCE.Close(this.handle);
    }

    public synchronized void dispose() {
        if (this.handle == null) {
            return;
        }
        MediaInfoLibrary.INSTANCE.Delete(this.handle);
        this.handle = null;
    }

    protected void finalize() {
        this.dispose();
    }

    public static String version() {
        return MediaInfo.staticOption("Info_Version");
    }

    public static String parameters() {
        return MediaInfo.staticOption("Info_Parameters");
    }

    public static String codecs() {
        return MediaInfo.staticOption("Info_Codecs");
    }

    public static String capacities() {
        return MediaInfo.staticOption("Info_Capacities");
    }

    public static String staticOption(String option) {
        return MediaInfo.staticOption(option, "");
    }

    public static String staticOption(String option, String value) {
        return MediaInfoLibrary.INSTANCE.Option(null, new WString(option), new WString(value)).toString();
    }

    static {
        if (Platform.isLinux()) {
            try {
                NativeLibrary.getInstance((String)"zen");
            }
            catch (LinkageError e) {
                Logger.getLogger(MediaInfo.class.getName()).warning("Failed to preload libzen");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InfoKind {
        Name,
        Text,
        Measure,
        Options,
        Name_Text,
        Measure_Text,
        Info,
        HowTo,
        Domain;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StreamKind {
        General,
        Video,
        Audio,
        Text,
        Chapters,
        Image,
        Menu;

    }
}

