/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.contentfinder.querybuilder.impl;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.commons.util.DamUtil;
import com.day.cq.search.result.Hit;
import com.day.cq.wcm.api.Page;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;

public final class ContentFinderHitBuilder {
    private static final Long ONE_MILLION = 1000000L;
    private static final int ELLIPSE_LENGTH = 3;
    private static final int MAX_EXCERPT_LENGTH = 32;
    private static final String DAM_THUMBNAIL = "cq5dam.thumbnail.48.48.png";

    private ContentFinderHitBuilder() {
    }

    public static Map<String, Object> buildGenericResult(Hit hit) throws RepositoryException {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        Resource resource = hit.getResource();
        Asset asset = DamUtil.resolveToAsset((Resource)resource);
        if (asset != null) {
            return ContentFinderHitBuilder.addAssetData(asset, hit, map);
        }
        Page page = ContentFinderHitBuilder.getPage(resource);
        if (page != null) {
            return ContentFinderHitBuilder.addPageData(page, hit, map);
        }
        return ContentFinderHitBuilder.addOtherData(hit, map);
    }

    private static Map<String, Object> addPageData(Page page, Hit hit, Map<String, Object> map) throws RepositoryException {
        String title = page.getName();
        if (StringUtils.isNotBlank((String)page.getTitle())) {
            title = page.getTitle();
        } else if (StringUtils.isNotBlank((String)page.getPageTitle())) {
            title = page.getPageTitle();
        } else if (StringUtils.isNotBlank((String)page.getNavigationTitle())) {
            title = page.getNavigationTitle();
        }
        String excerpt = hit.getExcerpt();
        if (StringUtils.isBlank((String)hit.getExcerpt()) && (excerpt = StringUtils.stripToEmpty((String)page.getDescription())).length() > 32) {
            excerpt = StringUtils.substring((String)excerpt, (int)0, (int)29) + "...";
        }
        map.put("path", page.getPath());
        map.put("name", page.getName());
        map.put("title", title);
        map.put("excerpt", excerpt);
        map.put("ddGroups", "page");
        map.put("type", "Page");
        map.put("lastModified", ContentFinderHitBuilder.getLastModified(page));
        return map;
    }

    private static Map<String, Object> addAssetData(Asset asset, Hit hit, Map<String, Object> map) throws RepositoryException {
        String title = asset.getName();
        if (StringUtils.isNotBlank((String)asset.getMetadataValue("dc:title"))) {
            title = asset.getMetadataValue("dc:title");
        }
        String excerpt = hit.getExcerpt();
        if (StringUtils.isBlank((String)hit.getExcerpt()) && (excerpt = StringUtils.stripToEmpty((String)asset.getMetadataValue("dc:description"))).length() > 32) {
            excerpt = StringUtils.substring((String)excerpt, (int)0, (int)29) + "...";
        }
        map.put("path", asset.getPath());
        map.put("name", asset.getName());
        map.put("title", title);
        map.put("excerpt", excerpt);
        map.put("mimeType", asset.getMimeType());
        map.put("size", ContentFinderHitBuilder.getSize(asset));
        map.put("ck", ContentFinderHitBuilder.getCK(asset));
        map.put("type", "Asset");
        map.put("lastModified", ContentFinderHitBuilder.getLastModified(asset));
        return map;
    }

    private static Map<String, Object> addOtherData(Hit hit, Map<String, Object> map) throws RepositoryException {
        Resource resource = hit.getResource();
        ValueMap properties = (ValueMap)resource.adaptTo(ValueMap.class);
        map.put("path", resource.getPath());
        map.put("name", resource.getName());
        map.put("title", properties.get("jcr:title", (Object)resource.getName()));
        map.put("excerpt", hit.getExcerpt());
        map.put("lastModified", ContentFinderHitBuilder.getLastModified(resource));
        map.put("type", "Data");
        return map;
    }

    private static long getLastModified(Asset asset) {
        if (asset.getLastModified() > 0L) {
            return asset.getLastModified();
        }
        Object obj = asset.getMetadata().get("jcr:lastModified");
        if (obj != null && obj instanceof Date) {
            return ((Date)obj).getTime();
        }
        return 0L;
    }

    private static long getLastModified(Page page) {
        if (page.getLastModified() != null) {
            return page.getLastModified().getTimeInMillis();
        }
        ValueMap properties = page.getProperties();
        Date lastModified = (Date)properties.get("cq:lastModified", Date.class);
        if (lastModified != null) {
            return lastModified.getTime();
        }
        return 0L;
    }

    private static long getLastModified(Resource resource) {
        ValueMap properties = (ValueMap)resource.adaptTo(ValueMap.class);
        Date cqLastModified = (Date)properties.get("cq:lastModified", Date.class);
        if (cqLastModified != null) {
            return cqLastModified.getTime();
        }
        Date jcrLastModified = (Date)properties.get("jcr:lastModified", Date.class);
        if (jcrLastModified != null) {
            return jcrLastModified.getTime();
        }
        return 0L;
    }

    private static long getSize(Asset asset) {
        Rendition original = asset.getOriginal();
        if (original == null) {
            return 0L;
        }
        return original.getSize();
    }

    private static long getCK(Asset asset) {
        try {
            Rendition resource = asset.getRendition(DAM_THUMBNAIL);
            Resource contentResource = resource.getChild("jcr:content");
            ValueMap properties = (ValueMap)contentResource.adaptTo(ValueMap.class);
            return (Long)properties.get("jcr:lastModified", (Object)0L) / ONE_MILLION;
        }
        catch (Exception ex) {
            return 0L;
        }
    }

    private static Page getPage(Resource resource) {
        Resource parent;
        if (resource == null) {
            return null;
        }
        if (resource.adaptTo(Page.class) != null) {
            return (Page)resource.adaptTo(Page.class);
        }
        if (StringUtils.equals((String)resource.getName(), (String)"jcr:content") && (parent = resource.getParent()) != null) {
            return (Page)parent.adaptTo(Page.class);
        }
        return null;
    }
}

