/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.contentfinder.querybuilder.impl.viewhandler;

import com.adobe.acs.commons.contentfinder.querybuilder.impl.viewhandler.ContentFinderConstants;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GQLToQueryBuilderConverter {
    private static final Logger log = LoggerFactory.getLogger(GQLToQueryBuilderConverter.class);
    public static final String DELIMITER = ",";
    public static final String CF_TYPE = "type";
    public static final String CF_PATH = "path";
    public static final String CF_FULLTEXT = "query";
    public static final String CF_MIMETYPE = "mimeType";
    public static final String CF_ORDER = "order";
    public static final String CF_LIMIT = "limit";
    public static final String CF_OFFSET = "offset";
    public static final String CF_NAME = "name";
    public static final String CF_TAGS = "tags";
    public static final int GROUP_PATH = 1;
    public static final int GROUP_TYPE = 2;
    public static final int GROUP_NAME = 3;
    public static final int GROUP_MIMETYPE = 4;
    public static final int GROUP_TAGS = 5;
    public static final int GROUP_FULLTEXT = 6;
    public static final int GROUP_PROPERTY_USERDEFINED = 10000;
    public static final int GROUP_ORDERBY_USERDEFINED = 110;
    public static final int GROUP_ORDERBY_SCORE = 100;
    public static final int GROUP_ORDERBY_MODIFIED = 101;
    public static final int DEFAULT_OFFSET = 0;
    public static final int DEFAULT_LIMIT = 20;

    private GQLToQueryBuilderConverter() {
    }

    public static boolean convertToQueryBuilder(SlingHttpServletRequest request) {
        return GQLToQueryBuilderConverter.has(request, "_ctqb") && "true".equals(GQLToQueryBuilderConverter.get(request, "_ctqb"));
    }

    public static Map<String, String> addPath(SlingHttpServletRequest request, Map<String, String> map) {
        if (GQLToQueryBuilderConverter.has(request, CF_PATH)) {
            map = GQLToQueryBuilderConverter.put(request, map, CF_PATH, 1, true);
        } else {
            map.put(CF_PATH, request.getRequestPathInfo().getSuffix());
        }
        return map;
    }

    public static Map<String, String> addType(SlingHttpServletRequest request, Map<String, String> map) {
        if (GQLToQueryBuilderConverter.has(request, CF_TYPE)) {
            map = GQLToQueryBuilderConverter.put(request, map, CF_TYPE, 2, true);
        }
        return map;
    }

    public static Map<String, String> addName(SlingHttpServletRequest request, Map<String, String> map) {
        if (GQLToQueryBuilderConverter.has(request, CF_NAME)) {
            map = GQLToQueryBuilderConverter.put(request, map, CF_NAME, "nodename", 3, true);
        }
        return map;
    }

    public static Map<String, String> addOrder(SlingHttpServletRequest request, Map<String, String> map, String queryString) {
        if (GQLToQueryBuilderConverter.has(request, CF_ORDER)) {
            int count = 1;
            for (String value : GQLToQueryBuilderConverter.getAll(request, CF_ORDER)) {
                value = StringUtils.trim((String)value);
                String orderGroupId = String.valueOf(110 + count) + "_group";
                boolean sortAsc = false;
                if (StringUtils.startsWith((String)value, (String)"-")) {
                    sortAsc = false;
                    value = StringUtils.removeStart((String)value, (String)"-");
                } else if (StringUtils.startsWith((String)value, (String)"+")) {
                    sortAsc = true;
                    value = StringUtils.removeStart((String)value, (String)"+");
                }
                map.put(orderGroupId, StringUtils.trim((String)value));
                map.put(orderGroupId + ".sort", sortAsc ? "asc" : "desc");
                ++count;
            }
        } else {
            boolean isPage = GQLToQueryBuilderConverter.isPage(GQLToQueryBuilderConverter.get(request, CF_TYPE));
            boolean isAsset = GQLToQueryBuilderConverter.isAsset(GQLToQueryBuilderConverter.get(request, CF_TYPE));
            String prefix = GQLToQueryBuilderConverter.getPropertyPrefix(request);
            if (StringUtils.isNotBlank((String)queryString)) {
                map.put("100_orderby", "@jcr:score");
                map.put("100_orderby.sort", "desc");
            }
            String modifiedOrderProperty = "@jcr:lastModified";
            if (isPage) {
                modifiedOrderProperty = "@" + prefix + "cq:lastModified";
            } else if (isAsset) {
                modifiedOrderProperty = "@" + prefix + "jcr:lastModified";
            }
            map.put("101_orderby", modifiedOrderProperty);
            map.put("101_orderby.sort", "desc");
        }
        return map;
    }

    public static Map<String, String> addMimeType(SlingHttpServletRequest request, Map<String, String> map) {
        boolean isAsset = GQLToQueryBuilderConverter.isAsset(GQLToQueryBuilderConverter.get(request, CF_TYPE));
        String prefix = GQLToQueryBuilderConverter.getPropertyPrefix(request);
        if (isAsset && GQLToQueryBuilderConverter.has(request, CF_MIMETYPE)) {
            map.put("4_group.1_property.operation", "like");
            map.put("4_group.1_property", prefix + "dc:format");
            map.put("4_group.1_property.value", "%" + GQLToQueryBuilderConverter.get(request, CF_MIMETYPE) + "%");
        }
        return map;
    }

    public static Map<String, String> addTags(SlingHttpServletRequest request, Map<String, String> map) {
        if (GQLToQueryBuilderConverter.has(request, CF_TAGS)) {
            String prefix = GQLToQueryBuilderConverter.getPropertyPrefix(request);
            String groupId = "5_group";
            String tagProperty = prefix + "cq:tags";
            map.put("5_group.p.or", "true");
            if (GQLToQueryBuilderConverter.hasMany(request, CF_TAGS)) {
                String[] tags = GQLToQueryBuilderConverter.getAll(request, CF_TAGS);
                int i = 1;
                for (String tag : tags) {
                    map.put("5_group." + i + "_property", tagProperty);
                    map.put("5_group." + i + "_tagid", tag);
                    ++i;
                }
            } else {
                map.put("5_group.1_property", tagProperty);
                map.put("5_group.1_tagid", GQLToQueryBuilderConverter.get(request, CF_TAGS));
            }
        }
        return map;
    }

    public static Map<String, String> addFulltext(SlingHttpServletRequest request, Map<String, String> map, String queryString) {
        if (StringUtils.isNotBlank((String)queryString)) {
            String groupId = "6_group";
            map.put("6_group.fulltext", queryString);
            map.put("6_group.p.or", "true");
        }
        return map;
    }

    public static Map<String, String> addLimitAndOffset(SlingHttpServletRequest request, Map<String, String> map) {
        if (GQLToQueryBuilderConverter.has(request, CF_LIMIT)) {
            String offset = String.valueOf(GQLToQueryBuilderConverter.getOffset(request));
            String limit = String.valueOf(GQLToQueryBuilderConverter.getLimit(request));
            map.put("p.offset", String.valueOf(offset));
            map.put("p.limit", limit);
        } else {
            map.put("p.limit", String.valueOf(20));
        }
        return map;
    }

    public static Map<String, String> addProperty(SlingHttpServletRequest request, Map<String, String> map, String requestKey, int count) {
        if (!ArrayUtils.contains((Object[])ContentFinderConstants.PROPERTY_BLACKLIST, (Object)requestKey)) {
            map = GQLToQueryBuilderConverter.putProperty(request, map, requestKey, "property", 10000 + count, true);
        } else {
            log.debug("Rejecting property [ {} ] due to blacklist match", (Object)requestKey);
        }
        return map;
    }

    public static boolean isValidProperty(String key) {
        return !ArrayUtils.contains((Object[])ContentFinderConstants.PROPERTY_BLACKLIST, (Object)key);
    }

    public static boolean hasMany(SlingHttpServletRequest request, String key) {
        RequestParameter rp = request.getRequestParameter(key);
        if (rp == null) {
            return false;
        }
        return GQLToQueryBuilderConverter.getAll(request, key).length > 1;
    }

    public static boolean has(SlingHttpServletRequest request, String key) {
        return request.getParameterValues(key) != null;
    }

    public static String get(SlingHttpServletRequest request, String key) {
        return StringUtils.trim((String)request.getRequestParameter(key).toString());
    }

    public static String[] getAll(SlingHttpServletRequest request, String key) {
        RequestParameter rp = request.getRequestParameter(key);
        if (rp == null) {
            return new String[0];
        }
        return StringUtils.split((String)rp.getString(), (String)DELIMITER);
    }

    public static Map<String, String> put(SlingHttpServletRequest request, Map<String, String> map, String predicate, int group, boolean or) {
        return GQLToQueryBuilderConverter.putAll(map, predicate, GQLToQueryBuilderConverter.getAll(request, predicate), group, or);
    }

    public static Map<String, String> put(SlingHttpServletRequest request, Map<String, String> map, String requestKey, String predicate, int group, boolean or) {
        return GQLToQueryBuilderConverter.putAll(map, predicate, GQLToQueryBuilderConverter.getAll(request, requestKey), group, or);
    }

    public static Map<String, String> putProperty(SlingHttpServletRequest request, Map<String, String> map, String requestKey, String predicate, int group, boolean or) {
        return GQLToQueryBuilderConverter.putAll(map, predicate, requestKey, "value", GQLToQueryBuilderConverter.getAll(request, requestKey), group, or);
    }

    public static Map<String, String> putAll(Map<String, String> map, String predicate, String[] values, int group, boolean or) {
        String groupId = String.valueOf(group) + "_group";
        int count = 1;
        for (String value : values) {
            String predicateId = count + "_" + predicate;
            map.put(groupId + "." + predicateId, StringUtils.trim((String)value));
            ++count;
        }
        map.put(groupId + ".p.or", String.valueOf(or));
        return map;
    }

    public static Map<String, String> putAll(Map<String, String> map, String predicate, String predicateValue, String predicateSuffix, String[] values, int group, boolean or) {
        String groupId = String.valueOf(group) + "_group";
        map.put(groupId + "." + predicate, predicateValue);
        int count = 1;
        for (String value : values) {
            String predicateId = predicate;
            String predicateSuffixId = count + "_" + predicateSuffix;
            map.put(groupId + "." + predicateId + "." + predicateSuffixId, StringUtils.trim((String)value));
            ++count;
        }
        map.put(groupId + ".p.or", String.valueOf(or));
        return map;
    }

    public static boolean isPage(String nodeType) {
        return StringUtils.equals((String)nodeType, (String)"cq:Page");
    }

    public static boolean isAsset(String nodeType) {
        return StringUtils.equals((String)nodeType, (String)"dam:Asset");
    }

    public static String getPropertyPrefix(SlingHttpServletRequest request) {
        boolean isPage = GQLToQueryBuilderConverter.isPage(GQLToQueryBuilderConverter.get(request, CF_TYPE));
        boolean isAsset = GQLToQueryBuilderConverter.isAsset(GQLToQueryBuilderConverter.get(request, CF_TYPE));
        String prefix = "";
        if (isPage) {
            prefix = "jcr:content/";
        } else if (isAsset) {
            prefix = "jcr:content/metadata/";
        }
        return prefix;
    }

    public static int getLimit(SlingHttpServletRequest request) {
        if (GQLToQueryBuilderConverter.has(request, CF_LIMIT)) {
            String value = GQLToQueryBuilderConverter.get(request, CF_LIMIT);
            String[] limits = StringUtils.split((String)value, (String)"..");
            if (value.matches("^(\\d)+\\.\\.(\\d)+$")) {
                return Integer.parseInt(limits[1]) - Integer.parseInt(limits[0]);
            }
            if (value.matches("^\\.\\.(\\d)+$")) {
                return Integer.parseInt(limits[0]);
            }
            if (value.matches("^(\\d)+\\.\\.$")) {
                return 20;
            }
            log.info("Could not find valid LIMIT for QueryBuilder-based ContentFinder: {}", (Object)value);
        } else {
            log.info("Could not find any LIMIT for QueryBuilder-based ContentFinder");
        }
        return 20;
    }

    public static int getOffset(SlingHttpServletRequest request) {
        if (GQLToQueryBuilderConverter.has(request, CF_LIMIT)) {
            String value = GQLToQueryBuilderConverter.get(request, CF_LIMIT);
            String[] offsets = StringUtils.split((String)value, (String)"..");
            if (value.matches("^(\\d)+\\.\\.(\\d)+$")) {
                return Integer.parseInt(offsets[0]);
            }
            if (value.matches("^\\.\\.(\\d)+$")) {
                return Integer.parseInt(offsets[0]);
            }
            if (value.matches("^(\\d)+\\.\\.$")) {
                return Integer.parseInt(offsets[0]);
            }
            log.info("Could not find valid OFFSET for QueryBuilder-based ContentFinder: {}", (Object)value);
        } else {
            log.info("Could not find any OFFSET for QueryBuilder-based ContentFinder");
        }
        return 0;
    }
}

