/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.dam.audio.impl;

import com.adobe.acs.commons.dam.audio.impl.AbstractFFMpegAudioProcess;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.handler.ffmpeg.FFMpegWrapper;
import com.day.cq.dam.video.FFMpegTranscodeProcess;
import com.day.cq.dam.video.VideoProfile;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.metadata.MetaDataMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.jcr.RepositoryException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="CQ DAM FFmpeg Audio Encode Process", description="Workflow process that transcodes audio files into different formats")
@Service
@Properties(value={@Property(name="process.label", value={"Encode Audio"}, propertyPrivate=true)})
public final class FFMpegAudioEncodeProcess
extends AbstractFFMpegAudioProcess {
    private static final Logger log = LoggerFactory.getLogger(FFMpegAudioEncodeProcess.class);

    String[] buildArguments(MetaDataMap metaData) {
        String processArgs = (String)metaData.get("PROCESS_ARGS", String.class);
        if (processArgs != null && !processArgs.equals("")) {
            return processArgs.split(",");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    protected void processAudio(MetaDataMap metaData, Asset asset, File tmpFile, WorkflowSession wfSession) throws IOException, RepositoryException {
        String[] videoProfiles;
        long start = System.currentTimeMillis();
        log.info("processing asset [{}]...", (Object)asset.getPath());
        ResourceResolver resolver = this.getResourceResolver(wfSession.getSession());
        for (String videoProfile : videoProfiles = this.getVideoProfiles(metaData)) {
            FileInputStream fis;
            File tmpWorkingDir;
            block13: {
                VideoProfile profile = VideoProfile.get((ResourceResolver)resolver, (String)videoProfile);
                if (profile == null) continue;
                log.info("processAudio: creating audio using profile [{}]", (Object)videoProfile);
                tmpWorkingDir = this.createTempDir(this.getWorkingDir());
                FFMpegWrapper ffmpegWrapper = FFMpegWrapper.fromProfile((File)tmpFile, (VideoProfile)profile, (File)tmpWorkingDir);
                ffmpegWrapper.setExecutableLocator(this.getLocator());
                fis = null;
                String renditionName = this.getRenditionName(ffmpegWrapper);
                File transcodedAudio = ffmpegWrapper.transcode();
                fis = new FileInputStream(transcodedAudio);
                asset.addRendition(renditionName, (InputStream)fis, ffmpegWrapper.getOutputMimetype());
                if (transcodedAudio.delete()) break block13;
                log.error("Transcoded audio file @ {} coud not be deleted");
            }
            IOUtils.closeQuietly((InputStream)fis);
            try {
                if (tmpWorkingDir == null) continue;
                FileUtils.deleteDirectory((File)tmpWorkingDir);
            }
            catch (IOException e) {
                log.warn("Could not delete ffmpeg's temporary working directory: {}", (Object)tmpWorkingDir.getPath());
            }
            continue;
            catch (IOException e) {
                try {
                    log.error(e.getMessage(), (Throwable)e);
                    log.error("processAudio: failed creating audio from profile [{}]: {}", (Object)videoProfile, (Object)e.getMessage());
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fis);
                    try {
                        if (tmpWorkingDir != null) {
                            FileUtils.deleteDirectory((File)tmpWorkingDir);
                        }
                    }
                    catch (IOException e2) {
                        log.warn("Could not delete ffmpeg's temporary working directory: {}", (Object)tmpWorkingDir.getPath());
                    }
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)fis);
                try {
                    if (tmpWorkingDir == null) continue;
                    FileUtils.deleteDirectory((File)tmpWorkingDir);
                }
                catch (IOException e3) {
                    log.warn("Could not delete ffmpeg's temporary working directory: {}", (Object)tmpWorkingDir.getPath());
                }
            }
        }
        if (log.isInfoEnabled()) {
            long time = System.currentTimeMillis() - start;
            log.info("finished processing asset [{}] in [{}ms].", (Object)asset.getPath(), (Object)time);
        }
    }

    public String[] getVideoProfiles(MetaDataMap metaData) {
        List profiles = this.getValuesFromArgs(FFMpegTranscodeProcess.Arguments.VIDEO_PROFILES.getArgumentName(), this.buildArguments(metaData));
        return profiles.toArray(new String[profiles.size()]);
    }

    private String getRenditionName(FFMpegWrapper ffmpegWrapper) {
        String outputFormat = ffmpegWrapper.getOutputExtension();
        String profileName = ffmpegWrapper.getProfileName();
        StringBuilder builder = new StringBuilder();
        builder.append("cq5dam.audio.").append(profileName);
        builder.append(".").append(outputFormat);
        return builder.toString();
    }
}

