/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.dam.impl;

import com.adobe.acs.commons.dam.AbstractRenditionModifyingProcess;
import com.day.cq.dam.api.Rendition;
import com.day.cq.workflow.WorkflowSession;
import com.day.image.Layer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=false)
@Service
@Property(name="process.label", value={"Add Watermark to Rendition"})
public final class AddWatermarkToRenditionProcess
extends AbstractRenditionModifyingProcess {
    private static ConcurrentMap<String, Object> watermarkLogCache = new ConcurrentHashMap<String, Object>();
    private static final Logger log = LoggerFactory.getLogger(AddWatermarkToRenditionProcess.class);
    private static final String ARG_WATERMARK = "watermark";
    private static final String WATERMARK_SPECIFIER = "watermark";

    private static void logMissingWatermark(String path) {
        if (watermarkLogCache.putIfAbsent(path, new Object()) == null) {
            log.warn("Watermark path {} is not found.", (Object)path);
        }
    }

    private static void logInvalidWatermark(String path) {
        if (watermarkLogCache.putIfAbsent(path, new Object()) == null) {
            log.warn("Watermark path {} is not valid.", (Object)path);
        }
    }

    private void addWatermark(Layer layer, Layer watermark) {
        layer.blit(watermark, 0, layer.getHeight() - watermark.getHeight(), watermark.getWidth(), watermark.getHeight(), 0, 0);
    }

    private Layer getLayer(String path, Session session) {
        if (path != null) {
            ResourceResolver resolver = this.getResourceResolver(session);
            Resource resource = resolver.getResource(path);
            if (resource != null) {
                Layer layer = (Layer)resource.adaptTo(Layer.class);
                if (layer != null) {
                    return layer;
                }
                AddWatermarkToRenditionProcess.logInvalidWatermark(path);
            } else {
                AddWatermarkToRenditionProcess.logMissingWatermark(path);
            }
        }
        return null;
    }

    @Override
    protected String getTempFileSpecifier() {
        return "watermark";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Layer processLayer(Layer layer, Rendition rendition, WorkflowSession workflowSession, String[] args) {
        String watermarkPath;
        String string = watermarkPath = this.getValuesFromArgs("watermark", args).size() > 0 ? (String)this.getValuesFromArgs("watermark", args).get(0) : null;
        if (watermarkPath != null) {
            Layer watermark = null;
            try {
                watermark = this.getLayer(watermarkPath, workflowSession.getSession());
                if (watermark == null) return layer;
                this.addWatermark(layer, watermark);
                return layer;
            }
            finally {
                if (watermark != null) {
                    watermark.dispose();
                    watermark = null;
                }
            }
        } else {
            log.info("No watermark specified. Skipping.");
        }
        return layer;
    }
}

