/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.email.impl;

import com.adobe.acs.commons.email.EmailService;
import com.day.cq.commons.mail.MailTemplate;
import com.day.cq.mailer.MessageGateway;
import com.day.cq.mailer.MessageGatewayService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.jcr.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrLookup;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.HtmlEmail;
import org.apache.commons.mail.SimpleEmail;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="ACS AEM Commons - E-mail Service", description="A Generic Email service that sends an email to a given list of recipients.")
@Service
public final class EmailServiceImpl
implements EmailService {
    private static final Logger log = LoggerFactory.getLogger(EmailServiceImpl.class);
    @Reference
    private MessageGatewayService messageGatewayService;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;

    @Override
    public List<String> sendEmail(String templatePath, Map<String, String> emailParams, String ... recipients) {
        ArrayList<String> failureList = new ArrayList<String>();
        if (recipients == null || recipients.length <= 0) {
            throw new IllegalArgumentException("Invalid Recipients");
        }
        ArrayList<InternetAddress> addresses = new ArrayList<InternetAddress>(recipients.length);
        for (String recipient : recipients) {
            try {
                addresses.add(new InternetAddress(recipient));
            }
            catch (AddressException e) {
                log.warn("Invalid email address {} passed to sendEmail(). Skipping.", (Object)recipient);
            }
        }
        InternetAddress[] iAddressRecipients = addresses.toArray(new InternetAddress[addresses.size()]);
        List<InternetAddress> failureInternetAddresses = this.sendEmail(templatePath, emailParams, iAddressRecipients);
        for (InternetAddress address : failureInternetAddresses) {
            failureList.add(address.toString());
        }
        return failureList;
    }

    @Override
    public List<InternetAddress> sendEmail(String templatePath, Map<String, String> emailParams, InternetAddress ... recipients) {
        ArrayList<InternetAddress> failureList = new ArrayList<InternetAddress>();
        if (recipients == null || recipients.length <= 0) {
            throw new IllegalArgumentException("Invalid Recipients");
        }
        if (StringUtils.isBlank((String)templatePath)) {
            throw new IllegalArgumentException("Template path is null or empty");
        }
        Email email = this.getEmail(templatePath, emailParams);
        if (email == null) {
            throw new IllegalArgumentException("Error while creating template");
        }
        MessageGateway messageGateway = this.messageGatewayService.getGateway(email.getClass());
        for (InternetAddress address : recipients) {
            try {
                email.setTo(Collections.singleton(address));
                messageGateway.send((Object)email);
            }
            catch (Exception e) {
                failureList.add(address);
                log.error("Exception sending email to " + address, (Throwable)e);
            }
        }
        return failureList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Email getEmail(String templatePath, Map<String, String> emailParams) {
        ResourceResolver resourceResolver = null;
        try {
            resourceResolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
            MailTemplate mailTemplate = MailTemplate.create((String)templatePath, (Session)((Session)resourceResolver.adaptTo(Session.class)));
            if (mailTemplate == null) {
                log.warn("Email template at {} could not be created.", (Object)templatePath);
                Email email = null;
                return email;
            }
            Class emailClass = templatePath.endsWith(".html") ? HtmlEmail.class : SimpleEmail.class;
            Email email = mailTemplate.getEmail(StrLookup.mapLookup(emailParams), emailClass);
            if (emailParams.containsKey("senderEmailAddress") && emailParams.containsKey("senderName")) {
                email.setFrom(emailParams.get("senderEmailAddress"), emailParams.get("senderName"));
            } else if (emailParams.containsKey("senderEmailAddress")) {
                email.setFrom(emailParams.get("senderEmailAddress"));
            }
            Email email2 = email;
            return email2;
        }
        catch (Exception e) {
            log.error("Unable to construct email from template " + templatePath, (Throwable)e);
        }
        finally {
            if (resourceResolver != null) {
                resourceResolver.close();
            }
        }
        return null;
    }

    protected void bindMessageGatewayService(MessageGatewayService messageGatewayService) {
        this.messageGatewayService = messageGatewayService;
    }

    protected void unbindMessageGatewayService(MessageGatewayService messageGatewayService) {
        if (this.messageGatewayService == messageGatewayService) {
            this.messageGatewayService = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }
}

