/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.forms.impl;

import com.adobe.acs.commons.forms.FormsRouter;
import com.adobe.acs.commons.util.PathInfoUtil;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="ACS AEM Commons - Forms Router", description="Provides functionality for routing ACS AEM Commons FORM Requests through AEM.", policy=ConfigurationPolicy.REQUIRE, metatype=true)
@Service
public class FormsRouterImpl
implements FormsRouter {
    private static final Logger log = LoggerFactory.getLogger(FormsRouterImpl.class);
    private static final String DEFAULT_SUFFIX = "/submit/form";
    private String suffix = "/submit/form";
    @Property(label="Forms Suffix", description="HTTP Request Suffix used to identify ACS AEM Commons Forms POST Requests and route them appropriately. [ Default: /submit/form ]", value={"/submit/form"})
    private static final String PROP_SUFFIX = "suffix";

    @Override
    public final String getFormSelector(SlingHttpServletRequest slingRequest) {
        String requestSuffix = slingRequest.getRequestPathInfo().getSuffix();
        if (StringUtils.equals((String)requestSuffix, (String)this.getSuffix()) || !StringUtils.startsWith((String)requestSuffix, (String)(this.getSuffix() + "/"))) {
            return null;
        }
        int segments = StringUtils.split((String)this.getSuffix(), (char)'/').length;
        if (segments < 1) {
            return null;
        }
        String formSelector = PathInfoUtil.getSuffixSegment(slingRequest, segments);
        return StringUtils.stripToNull((String)formSelector);
    }

    @Override
    public final String getSuffix() {
        return this.suffix;
    }

    @Override
    public final boolean hasValidSuffix(SlingHttpServletRequest slingRequest) {
        String requestSuffix = slingRequest.getRequestPathInfo().getSuffix();
        return StringUtils.equals((String)requestSuffix, (String)this.getSuffix()) || StringUtils.startsWith((String)requestSuffix, (String)(this.getSuffix() + "/"));
    }

    @Activate
    protected final void activate(Map<String, String> properties) {
        this.suffix = PropertiesUtil.toString((Object)properties.get(PROP_SUFFIX), (String)DEFAULT_SUFFIX);
        if (StringUtils.isBlank((String)this.suffix)) {
            this.suffix = DEFAULT_SUFFIX;
        }
        log.debug("Forms Router suffix: {}", (Object)this.suffix);
    }
}

