/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.images.transformers.impl;

import com.adobe.acs.commons.images.ImageTransformer;
import com.day.image.Layer;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="ACS AEM Commons - Image Transformer - Rotate")
@Properties(value={@Property(name="type", value={"rotate"}, propertyPrivate=true)})
@Service
public class RotateImageTransformerImpl
implements ImageTransformer {
    private static final Logger log = LoggerFactory.getLogger(RotateImageTransformerImpl.class);
    static final String TYPE = "rotate";
    private static final String KEY_DEGREES = "degrees";
    private static final int TOTAL_DEGREES = 360;

    @Override
    public final Layer transform(Layer layer, ValueMap properties) {
        if (properties == null || properties.isEmpty()) {
            log.warn("Transform [ {} ] requires parameters.", (Object)TYPE);
            return layer;
        }
        log.debug("Transforming with [ {} ]", (Object)TYPE);
        int degrees = (Integer)properties.get(KEY_DEGREES, (Object)0) % 360;
        layer.rotate((double)degrees);
        return layer;
    }
}

