/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.quickly;

import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Command {
    private static final Logger log = LoggerFactory.getLogger(Command.class);
    private static final String[] PUNCTUATIONS = new String[]{"!"};
    public static final String REQUEST_PARAM_CMD = "cmd";
    private final String raw;
    private final String operation;
    private final String param;
    private final String[] params;
    private final String[] punctuation;

    public Command(SlingHttpServletRequest request) {
        this(request.getParameter(REQUEST_PARAM_CMD));
    }

    public Command(String raw) {
        this.raw = StringUtils.stripToEmpty((String)raw);
        String opWithPunctuation = StringUtils.stripToEmpty((String)StringUtils.lowerCase((String)StringUtils.substringBefore((String)this.raw, (String)" ")));
        int punctuationIndex = StringUtils.indexOfAny((String)opWithPunctuation, (String[])PUNCTUATIONS);
        if (punctuationIndex > 0) {
            this.punctuation = StringUtils.substring((String)opWithPunctuation, (int)punctuationIndex).split("(?!^)");
            this.operation = StringUtils.substring((String)opWithPunctuation, (int)0, (int)punctuationIndex);
        } else {
            this.punctuation = new String[0];
            this.operation = opWithPunctuation;
        }
        this.param = StringUtils.stripToEmpty((String)StringUtils.removeStart((String)this.raw, (String)opWithPunctuation));
        this.params = StringUtils.split((String)this.param);
        if (log.isTraceEnabled()) {
            log.trace("Raw: {}", (Object)this.raw);
            log.trace("Operation: {}", (Object)this.operation);
            log.trace("Punctuation: {}", (Object)Arrays.toString(this.punctuation));
            log.trace("Param: {}", (Object)this.param);
            log.trace("Params: {}", (Object)Arrays.toString(this.params));
        }
    }

    public String getOp() {
        return this.operation;
    }

    public String getParam() {
        return this.param;
    }

    public String toString() {
        return this.raw;
    }

    public String[] getParams() {
        return Arrays.copyOf(this.params, this.params.length);
    }

    public String[] getPunctuation() {
        return Arrays.copyOf(this.punctuation, this.punctuation.length);
    }
}

