/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.quickly.impl;

import com.adobe.acs.commons.quickly.Command;
import com.adobe.acs.commons.quickly.QuicklyEngine;
import com.adobe.acs.commons.quickly.operations.Operation;
import com.adobe.acs.commons.quickly.results.Result;
import com.adobe.acs.commons.quickly.results.ResultBuilder;
import com.day.cq.wcm.api.AuthoringUIMode;
import com.day.cq.wcm.api.AuthoringUIModeService;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="ACS AEM Commons - Quickly", metatype=true, policy=ConfigurationPolicy.REQUIRE)
@Reference(name="operations", referenceInterface=Operation.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE)
@Service
public class QuicklyEngineImpl
implements QuicklyEngine {
    private static final Logger log = LoggerFactory.getLogger(QuicklyEngineImpl.class);
    private static final String KEY_RESULTS = "results";
    private ValueMap config;
    private static final String[] DEFAULT_RESULT_MODES = new String[0];
    @Property(label="Result Modes", description="Additive - options: [ dev ], [ blank is the baseline ]", cardinality=100, value={})
    public static final String PROP_RESULT_MODES = "result.modes";
    @Reference
    private AuthoringUIModeService authoringUIModeService;
    @Reference(target="(cmd=go)")
    private Operation defaultOperation;
    @Reference
    private ResultBuilder resultBuilder;
    private Map<String, Operation> operations = new ConcurrentHashMap<String, Operation>();

    @Override
    public final JSONObject execute(SlingHttpServletRequest request, SlingHttpServletResponse response, Command cmd) throws JSONException {
        for (Operation operation : this.operations.values()) {
            if (!operation.accepts(request, cmd)) continue;
            return this.getJSONResults(cmd, request, operation.getResults(request, response, cmd));
        }
        Command defaultCmd = new Command(this.defaultOperation.getCmd() + " " + cmd.toString());
        return this.getJSONResults(cmd, request, this.defaultOperation.getResults(request, response, defaultCmd));
    }

    private JSONObject getJSONResults(Command cmd, SlingHttpServletRequest request, Collection<Result> results) throws JSONException {
        JSONObject json = new JSONObject();
        json.put(KEY_RESULTS, (Object)new JSONArray());
        ValueMapDecorator requestConfig = new ValueMapDecorator(new HashMap());
        requestConfig.putAll((Map)this.config);
        requestConfig.put((Object)AuthoringUIMode.class.getName(), (Object)this.authoringUIModeService.getAuthoringUIMode(request));
        for (Result result : results) {
            JSONObject tmp = this.resultBuilder.toJSON(cmd, result, (ValueMap)requestConfig);
            if (tmp == null) continue;
            json.accumulate(KEY_RESULTS, (Object)tmp);
        }
        return json;
    }

    protected final void bindOperations(Operation service, Map<Object, Object> props) {
        String cmd = PropertiesUtil.toString((Object)props.get("cmd"), null);
        if (cmd != null) {
            log.debug("Collected Quickly Operation [ {} ]", (Object)cmd);
            this.operations.put(cmd, service);
        }
    }

    protected final void unbindOperations(Operation service, Map<Object, Object> props) {
        String cmd = PropertiesUtil.toString((Object)props.get("cmd"), null);
        if (cmd != null) {
            log.debug("Discarded Quickly Operation [ {} ]", (Object)cmd);
            this.operations.remove(cmd);
        }
    }

    @Activate
    protected final void activate(Map<String, String> map) {
        this.config = new ValueMapDecorator(new HashMap());
        this.config.put((Object)KEY_RESULTS, (Object)PropertiesUtil.toStringArray((Object)map.get(PROP_RESULT_MODES), (String[])DEFAULT_RESULT_MODES));
    }

    protected void bindAuthoringUIModeService(AuthoringUIModeService authoringUIModeService) {
        this.authoringUIModeService = authoringUIModeService;
    }

    protected void unbindAuthoringUIModeService(AuthoringUIModeService authoringUIModeService) {
        if (this.authoringUIModeService == authoringUIModeService) {
            this.authoringUIModeService = null;
        }
    }

    protected void bindDefaultOperation(Operation operation) {
        this.defaultOperation = operation;
    }

    protected void unbindDefaultOperation(Operation operation) {
        if (this.defaultOperation == operation) {
            this.defaultOperation = null;
        }
    }

    protected void bindResultBuilder(ResultBuilder resultBuilder) {
        this.resultBuilder = resultBuilder;
    }

    protected void unbindResultBuilder(ResultBuilder resultBuilder) {
        if (this.resultBuilder == resultBuilder) {
            this.resultBuilder = null;
        }
    }
}

