/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.quickly.operations.impl;

import com.adobe.acs.commons.quickly.Command;
import com.adobe.acs.commons.quickly.operations.AbstractOperation;
import com.adobe.acs.commons.quickly.results.Action;
import com.adobe.acs.commons.quickly.results.Result;
import com.adobe.acs.commons.quickly.results.impl.lists.ACSToolsResults;
import com.adobe.acs.commons.quickly.results.impl.lists.ClassicConsoleResults;
import com.adobe.acs.commons.quickly.results.impl.lists.DevConsoleResults;
import com.adobe.acs.commons.quickly.results.impl.lists.OpsConsoleResults;
import com.adobe.acs.commons.quickly.results.impl.lists.TouchConsoleResults;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="ACS AEM Commons - Quickly - Go Operation")
@Properties(value={@Property(name="cmd", value={"go"}, propertyPrivate=true), @Property(name="description", value={"Go straight to specific consoles in AEM"}, propertyPrivate=true)})
@Service
public class GoOperationImpl
extends AbstractOperation {
    public static final String CMD = "go";
    private static final Logger log = LoggerFactory.getLogger(GoOperationImpl.class);

    @Override
    public boolean accepts(SlingHttpServletRequest request, Command cmd) {
        return StringUtils.equalsIgnoreCase((String)CMD, (String)cmd.getOp());
    }

    @Override
    public String getCmd() {
        return CMD;
    }

    @Override
    protected List<Result> withoutParams(SlingHttpServletRequest request, SlingHttpServletResponse response, Command cmd) {
        return this.buildShortcuts(request.getResourceResolver());
    }

    @Override
    protected List<Result> withParams(SlingHttpServletRequest request, SlingHttpServletResponse response, Command cmd) {
        ArrayList<Result> results = new ArrayList<Result>();
        for (Result shortcut : this.buildShortcuts(request.getResourceResolver())) {
            if (!StringUtils.containsIgnoreCase((String)shortcut.getTitle(), (String)cmd.getParam())) continue;
            results.add(shortcut);
        }
        return results;
    }

    private List<Result> buildShortcuts(ResourceResolver resourceResolver) {
        ArrayList<Result> shortcuts = new ArrayList<Result>();
        shortcuts.addAll(new ClassicConsoleResults().getResults(resourceResolver));
        shortcuts.addAll(new TouchConsoleResults().getResults(resourceResolver));
        shortcuts.addAll(DevConsoleResults.getResults());
        shortcuts.addAll(new OpsConsoleResults().getResults());
        shortcuts.addAll(new ACSToolsResults().getResults(resourceResolver));
        shortcuts.add(new Result.Builder("touch").description("Switch to Touch UI").action(new Action.Builder().script("document.cookie='cq-authoring-mode=TOUCH;path=/;'").build()).classic().build());
        shortcuts.add(new Result.Builder("classic").description("Switch to Classic UI").action(new Action.Builder().script("document.cookie='cq-authoring-mode=CLASSIC;path=/;'").build()).classic().touch().build());
        return shortcuts;
    }
}

