/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.quickly.operations.impl;

import com.adobe.acs.commons.quickly.Command;
import com.adobe.acs.commons.quickly.operations.AbstractOperation;
import com.adobe.acs.commons.quickly.results.Result;
import com.adobe.acs.commons.quickly.results.impl.lists.HelpResults;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="ACS AEM Commons - Quickly - Help Operation")
@Properties(value={@Property(name="cmd", value={"help"}, propertyPrivate=true)})
@Service
public class HelpOperationImpl
extends AbstractOperation {
    private static final Logger log = LoggerFactory.getLogger(HelpOperationImpl.class);
    public static final String CMD = "help";
    public static final String CMD_ALIAS = "?";
    private static List<Result> operations = new HelpResults().getResults();

    @Override
    public boolean accepts(SlingHttpServletRequest request, Command cmd) {
        return StringUtils.equalsIgnoreCase((String)CMD, (String)cmd.getOp()) || StringUtils.equalsIgnoreCase((String)CMD_ALIAS, (String)cmd.getOp());
    }

    @Override
    public String getCmd() {
        return CMD;
    }

    @Override
    protected List<Result> withoutParams(SlingHttpServletRequest request, SlingHttpServletResponse response, Command cmd) {
        return new ArrayList<Result>(operations);
    }

    @Override
    protected List<Result> withParams(SlingHttpServletRequest request, SlingHttpServletResponse response, Command cmd) {
        ArrayList<Result> results = new ArrayList<Result>();
        for (Result result : operations) {
            if (!StringUtils.startsWithIgnoreCase((String)result.getTitle(), (String)cmd.getParam())) continue;
            results.add(result);
        }
        return results;
    }
}

