/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.quickly.results.impl.serializers;

import com.adobe.acs.commons.quickly.results.Action;
import com.adobe.acs.commons.quickly.results.Result;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractResultSerializer {
    private static final Logger log = LoggerFactory.getLogger(AbstractResultSerializer.class);

    public JSONObject toJSON(Result result, ValueMap config) throws JSONException {
        JSONObject json = new JSONObject();
        json.put("title", (Object)result.getTitle());
        json.put("type", (Object)result.getResultType());
        json.put("description", (Object)result.getDescription());
        json.put("path", (Object)result.getPath());
        json.put("action", (Object)this.toJSON(result.getAction()));
        json.put("secondaryAction", (Object)this.toJSON(result.getSecondaryAction()));
        return json;
    }

    public JSONObject toJSON(Action action) throws JSONException {
        JSONObject json = new JSONObject();
        if (action != null) {
            json.put("uri", (Object)action.getUri());
            json.put("method", (Object)action.getMethod());
            json.put("target", (Object)action.getTarget());
            json.put("xhr", false);
            json.put("script", (Object)action.getScript());
            json.put("params", (Object)new JSONObject(action.getParams()));
        }
        return json;
    }
}

