/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.replication.impl;

import com.adobe.acs.commons.replication.ReplicateVersion;
import com.adobe.acs.commons.replication.ReplicationResult;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(label="ACS AEM Commons - Replicate Version Servlet", description="Servlet end-point used to initiate replication of resource versions.", resourceTypes={"acs-commons/components/utilities/version-replicator"}, selectors={"replicateversion"}, extensions={"json"}, methods={"POST"}, generateComponent=true)
public class ReplicateVersionServlet
extends SlingAllMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(ReplicateVersionServlet.class);
    @Reference
    private ReplicateVersion replicateVersion;

    public final void doPost(SlingHttpServletRequest req, SlingHttpServletResponse res) throws ServletException, IOException {
        log.debug("Entering ReplicatePageVersionServlet.doPost(..)");
        JSONObject obj = null;
        try {
            String[] rootPaths = req.getParameterValues("rootPaths");
            Date date = this.getDate(req.getParameter("datetimecal"));
            String[] agents = req.getParameterValues("cmbAgent");
            obj = this.validate(rootPaths, agents, date);
            if (!obj.has("error")) {
                log.debug("Initiating version replication");
                List<ReplicationResult> response = this.replicateVersion.replicate(req.getResourceResolver(), rootPaths, agents, date);
                if (log.isDebugEnabled()) {
                    for (ReplicationResult replicationResult : response) {
                        log.debug("Replication result: {} -- {}", (Object)replicationResult.getPath(), (Object)replicationResult.getStatus());
                    }
                }
                JSONArray arr = this.convertResponseToJson(response);
                obj = new JSONObject();
                obj.put("result", (Object)arr);
            } else {
                log.debug("Did not attempt to replicate version due to issue with input params");
                try {
                    res.setStatus(500);
                    obj.put("status", (Object)"error");
                }
                catch (JSONException e) {
                    log.error("exception occurred", (Throwable)e);
                }
            }
        }
        catch (JSONException ex) {
            try {
                if (obj == null) {
                    obj = new JSONObject();
                }
                res.setStatus(500);
                obj.put("error", (Object)"System Error.");
                obj.put("status", (Object)"error");
            }
            catch (JSONException e) {
                log.error("exception occurred", (Throwable)e);
            }
        }
        try {
            res.setContentType("application/json");
            obj.write((Writer)res.getWriter());
        }
        catch (JSONException e) {
            log.error("exception occurred", (Throwable)e);
        }
    }

    private JSONArray convertResponseToJson(List<ReplicationResult> list) throws JSONException {
        JSONArray arr = new JSONArray();
        for (ReplicationResult result : list) {
            JSONObject resultObject = new JSONObject();
            resultObject.put("path", (Object)result.getPath());
            resultObject.put("status", (Object)result.getStatus().name());
            resultObject.put("version", (Object)result.getVersion());
            arr.put((Object)resultObject);
        }
        return arr;
    }

    private JSONObject validate(String[] rootPaths, String[] agents, Date date) throws JSONException {
        JSONObject obj = new JSONObject();
        if (ArrayUtils.isEmpty((Object[])rootPaths)) {
            obj.put("error", (Object)"Select at least 1 root path.");
            log.debug("Error validating root paths (they're empty)");
            return obj;
        }
        for (String rootPath : rootPaths) {
            if (!StringUtils.isBlank((String)rootPath)) continue;
            obj.put("error", (Object)"Root paths cannot be empty.");
            log.debug("Error validating a root path");
            return obj;
        }
        if (date == null) {
            obj.put("error", (Object)"Specify the date and time to select the appropriate resource versions for replication.");
            log.debug("Error validating date");
            return obj;
        }
        if (ArrayUtils.isEmpty((Object[])agents)) {
            obj.put("error", (Object)"Select at least 1 replication agent.");
            log.debug("Error validating agents");
            return obj;
        }
        log.debug("Validated all version replication inputs successfully");
        return obj;
    }

    private Date getDate(String datetime) {
        Date date = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss aa");
            date = sdf.parse(datetime);
        }
        catch (Exception e) {
            log.error("exception occurred", (Throwable)e);
        }
        return date;
    }

    protected void bindReplicateVersion(ReplicateVersion replicateVersion) {
        this.replicateVersion = replicateVersion;
    }

    protected void unbindReplicateVersion(ReplicateVersion replicateVersion) {
        if (this.replicateVersion == replicateVersion) {
            this.replicateVersion = null;
        }
    }
}

