/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.social.linkedin;

import aQute.bnd.annotation.ProviderType;
import org.apache.commons.lang.RandomStringUtils;
import org.scribe.builder.api.DefaultApi20;
import org.scribe.extractors.AccessTokenExtractor;
import org.scribe.extractors.JsonTokenExtractor;
import org.scribe.model.OAuthConfig;
import org.scribe.model.OAuthRequest;
import org.scribe.model.Response;
import org.scribe.model.Token;
import org.scribe.model.Verb;
import org.scribe.model.Verifier;
import org.scribe.oauth.OAuth20ServiceImpl;
import org.scribe.oauth.OAuthService;
import org.scribe.utils.OAuthEncoder;
import org.scribe.utils.Preconditions;

@ProviderType
public final class LinkedInApi20
extends DefaultApi20 {
    private static final String ACCESS_TOKEN_URL = "https://www.linkedin.com/uas/oauth2/accessToken";
    private static final String AUTHORIZE_URL = "https://www.linkedin.com/uas/oauth2/authorization?response_type=code&client_id=%s&state=%s&redirect_uri=%s";
    private static final String SCOPED_AUTHORIZE_URL = "https://www.linkedin.com/uas/oauth2/authorization?response_type=code&client_id=%s&state=%s&redirect_uri=%s&scope=%s";
    private final String state;

    public LinkedInApi20() {
        this(RandomStringUtils.randomAlphanumeric((int)10));
    }

    public LinkedInApi20(String state) {
        this.state = state;
    }

    public OAuthService createService(OAuthConfig config) {
        return new LinkedIn20Service(this, config);
    }

    public String getAccessTokenEndpoint() {
        return ACCESS_TOKEN_URL;
    }

    public AccessTokenExtractor getAccessTokenExtractor() {
        return new JsonTokenExtractor();
    }

    public Verb getAccessTokenVerb() {
        return Verb.POST;
    }

    public String getAuthorizationUrl(OAuthConfig config) {
        Preconditions.checkValidUrl((String)config.getCallback(), (String)"Must provide a valid url as callback. LinkedIn does not support Out Of Band Auth.");
        if (config.hasScope()) {
            return String.format(SCOPED_AUTHORIZE_URL, config.getApiKey(), OAuthEncoder.encode((String)this.state), OAuthEncoder.encode((String)config.getCallback()), OAuthEncoder.encode((String)config.getScope()));
        }
        return String.format(AUTHORIZE_URL, config.getApiKey(), OAuthEncoder.encode((String)this.state), OAuthEncoder.encode((String)config.getCallback()));
    }

    public String getState() {
        return this.state;
    }

    private static final class LinkedIn20Service
    extends OAuth20ServiceImpl {
        private LinkedInApi20 api;
        private OAuthConfig config;

        private LinkedIn20Service(LinkedInApi20 api, OAuthConfig config) {
            super((DefaultApi20)api, config);
            this.api = api;
            this.config = config;
        }

        public void signRequest(Token accessToken, OAuthRequest request) {
            request.addQuerystringParameter("oauth2_access_token", accessToken.getToken());
        }

        public Token getAccessToken(Token requestToken, Verifier verifier) {
            OAuthRequest request = new OAuthRequest(this.api.getAccessTokenVerb(), this.api.getAccessTokenEndpoint());
            request.addQuerystringParameter("client_id", this.config.getApiKey());
            request.addQuerystringParameter("client_secret", this.config.getApiSecret());
            request.addQuerystringParameter("code", verifier.getValue());
            request.addQuerystringParameter("redirect_uri", this.config.getCallback());
            request.addQuerystringParameter("grant_type", "authorization_code");
            if (this.config.hasScope()) {
                request.addQuerystringParameter("scope", this.config.getScope());
            }
            Response response = request.send();
            return this.api.getAccessTokenExtractor().extract(response.getBody());
        }
    }
}

