/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.util;

import aQute.bnd.annotation.ProviderType;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

@ProviderType
public final class BufferingResponse
extends HttpServletResponseWrapper {
    private StringWriter stringWriter;
    private boolean outputStreamGotten;

    public BufferingResponse(HttpServletResponse response) {
        super(response);
    }

    public void resetBuffer() {
        if (this.stringWriter != null) {
            this.stringWriter = new StringWriter();
        }
        super.resetBuffer();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.stringWriter != null) {
            throw new IllegalStateException("Cannot invoke getOutputStream() once getWriter() has been called.");
        }
        ServletOutputStream os = super.getOutputStream();
        this.outputStreamGotten = true;
        return os;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.outputStreamGotten) {
            throw new IllegalStateException("Cannot invoke getWriter once getOutputStream has been called.");
        }
        if (this.stringWriter == null) {
            this.stringWriter = new StringWriter();
        }
        return new PrintWriter(this.stringWriter);
    }

    public String getContents() {
        if (this.stringWriter != null) {
            return this.stringWriter.toString();
        }
        return null;
    }
}

