/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.util;

import com.adobe.acs.commons.util.TypeUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InfoWriter {
    private static final Logger log = LoggerFactory.getLogger(InfoWriter.class);
    private static final int LINE_LENGTH = 80;
    private static final String LINE_CHAR = "-";
    private StringWriter sw = new StringWriter();
    private PrintWriter pw = new PrintWriter(this.sw);

    public String toString() {
        return this.sw.toString();
    }

    public void title() {
        this.title(null);
    }

    public void title(String title) {
        this.pw.println();
        this.pw.println(StringUtils.repeat((String)LINE_CHAR, (int)80));
        if (StringUtils.isNotBlank((String)title)) {
            this.pw.println(title);
            this.pw.println(StringUtils.repeat((String)"=", (int)80));
        }
    }

    public void message(String message, Object ... vars) {
        if (ArrayUtils.isEmpty((Object[])vars)) {
            this.pw.println(message);
        } else {
            for (Object var : vars) {
                try {
                    message = StringUtils.replaceOnce((String)message, (String)"{}", (String)TypeUtil.toString(var));
                }
                catch (Exception e) {
                    log.error("Could not derive a valid String representation for {} using TypeUtil.toString(..)", var, (Object)e);
                    message = StringUtils.replaceOnce((String)message, (String)"{}", (String)"???");
                }
            }
            this.pw.println(message);
        }
    }

    public void end() {
        this.line();
    }

    public void line() {
        this.line(0);
    }

    public void line(int indent) {
        if (indent < 0) {
            indent = 0;
        }
        this.pw.println(StringUtils.repeat((String)" ", (int)indent) + StringUtils.repeat((String)LINE_CHAR, (int)(80 - indent)));
    }
}

