/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.wcm.impl;

import com.adobe.acs.commons.util.PathInfoUtil;
import com.adobe.acs.commons.wcm.impl.AbstractWidgetConfigurationServlet;
import com.adobe.granite.xss.XSSAPI;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.commons.osgi.PropertiesUtil;

@SlingServlet(extensions={"json"}, selectors={"rte"}, resourceTypes={"sling/servlet/default"})
public final class RTEConfigurationServlet
extends AbstractWidgetConfigurationServlet {
    private static final int RTE_HEIGHT = 200;
    private static final int RTE_WIDTH = 430;
    private static final String DEFAULT_CONFIG_NAME = "default";
    @Reference
    private XSSAPI xssApi;
    private static final String DEFAULT_CONFIG = "/libs/foundation/components/text/dialog/items/tab1/items/text/rtePlugins";
    private static final String DEFAULT_ROOT_PATH = "/etc/rteconfig";
    @Property(value={"/etc/rteconfig"})
    private static final String PROP_ROOT_PATH = "root.path";
    private static final String EXTERNAL_STYLESHEETS_PROPERTY = "externalStyleSheets";
    private String rootPath;

    @Override
    protected JSONObject createEmptyWidget(String rteName) throws JSONException {
        JSONObject object = new JSONObject();
        object.put("xtype", (Object)"richtext");
        object.put("name", (Object)("./" + this.xssApi.encodeForJSString(rteName)));
        object.put("hideLabel", true);
        object.put("jcr:primaryType", (Object)"cq:Widget");
        return object;
    }

    private void returnDefault(String rteName, SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException, ServletException {
        response.setContentType("application/json");
        try {
            Resource root = request.getResourceResolver().getResource(DEFAULT_CONFIG);
            if (root == null) {
                this.writeEmptyWidget(rteName, response);
                return;
            }
            this.writeConfigResource(root, rteName, true, request, response);
        }
        catch (JSONException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private void writeConfigResource(Resource resource, String rteName, boolean isDefault, SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException, JSONException, ServletException {
        JSONObject config;
        JSONObject widget = this.createEmptyWidget(rteName);
        widget.put("width", 430);
        widget.put("height", 200);
        RequestParameterMap map = request.getRequestParameterMap();
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            RequestParameter[] params = (RequestParameter[])entry.getValue();
            if (params == null) continue;
            if (params.length > 1 || EXTERNAL_STYLESHEETS_PROPERTY.equals(key)) {
                JSONArray arr = new JSONArray();
                for (int i = 0; i < params.length; ++i) {
                    arr.put((Object)params[i].getString());
                }
                widget.put(key, (Object)arr);
                continue;
            }
            if (params.length != 1) continue;
            widget.put(key, (Object)params[0].getString());
        }
        if (widget.has("fieldLabel")) {
            widget.remove("hideLabel");
        }
        if ((config = this.toJSONObject(resource)) == null) {
            config = new JSONObject();
        }
        if (config.optBoolean("includeDefault")) {
            config = this.underlay(config, resource.getResourceResolver().getResource(DEFAULT_CONFIG));
        }
        widget.put("rtePlugins", (Object)config);
        JSONObject parent = new JSONObject();
        parent.put("xtype", (Object)"dialogfieldset");
        parent.put("border", false);
        parent.put("padding", 0);
        parent.accumulate("items", (Object)widget);
        parent.write((Writer)response.getWriter());
    }

    @Activate
    protected void activate(Map<String, Object> props) {
        this.rootPath = PropertiesUtil.toString((Object)props.get(PROP_ROOT_PATH), (String)DEFAULT_ROOT_PATH);
    }

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        String componentPath = request.getResource().getPath();
        String configName = PathInfoUtil.getSelector(request, 1, DEFAULT_CONFIG_NAME);
        String rteName = PathInfoUtil.getSelector(request, 2, "text");
        Resource root = request.getResourceResolver().getResource(this.rootPath);
        if (root != null) {
            Iterator children = root.listChildren();
            while (children.hasNext()) {
                Resource child = (Resource)children.next();
                if (!this.matches(componentPath, child)) continue;
                boolean isDefault = false;
                Resource config = child.getChild(configName);
                if (config == null) {
                    config = child.getChild(DEFAULT_CONFIG_NAME);
                    isDefault = true;
                }
                if (config == null) continue;
                try {
                    this.writeConfigResource(config, rteName, isDefault, request, response);
                }
                catch (JSONException e) {
                    throw new ServletException((Throwable)e);
                }
                return;
            }
        }
        this.returnDefault(rteName, request, response);
    }

    protected void bindXssApi(XSSAPI xSSAPI) {
        this.xssApi = xSSAPI;
    }

    protected void unbindXssApi(XSSAPI xSSAPI) {
        if (this.xssApi == xSSAPI) {
            this.xssApi = null;
        }
    }
}

