/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.workflow.bulk.impl;

import com.adobe.acs.commons.workflow.bulk.impl.BulkWorkflowEngineImpl;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.sling.api.resource.AbstractResourceVisitor;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResumableResourceVisitor
extends AbstractResourceVisitor {
    private static final Logger log = LoggerFactory.getLogger(BulkWorkflowEngineImpl.class);
    private static final String BULK_WORKFLOW_MANAGER_PAGE_FOLDER_PATH = "/etc/acs-commons/bulk-workflow-manager";
    private static final String NT_PAGE_CONTENT = "cq:PageContent";
    private static final String[] ACCEPTED_PRIMARY_TYPES = new String[]{"cq:Page", "cq:PageContent"};
    private List<Resource> resources = new ArrayList<Resource>();

    public final List<Resource> getResumableResources() {
        return this.resources;
    }

    public final void accept(Resource resource) {
        ValueMap properties = (ValueMap)resource.adaptTo(ValueMap.class);
        String primaryType = (String)properties.get("jcr:primaryType", String.class);
        if (BULK_WORKFLOW_MANAGER_PAGE_FOLDER_PATH.equals(resource.getPath())) {
            super.accept(resource);
        } else if (ArrayUtils.contains((Object[])ACCEPTED_PRIMARY_TYPES, (Object)primaryType)) {
            super.accept(resource);
        }
    }

    protected void visit(Resource resource) {
        ValueMap properties = (ValueMap)resource.adaptTo(ValueMap.class);
        if (NT_PAGE_CONTENT.equals(properties.get("jcr:primaryType", String.class)) && "acs-commons/components/utilities/bulk-workflow-manager".equals(properties.get("sling:resourceType", String.class)) && "stopped-deactivated".equals(properties.get("state", String.class))) {
            this.resources.add(resource);
        }
    }
}

