/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.workflow.bulk.removal.impl;

import com.adobe.acs.commons.workflow.bulk.removal.WorkflowInstanceRemover;
import com.adobe.acs.commons.workflow.bulk.removal.impl.WorkflowRemovalException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="ACS AEM Commons - Workflow Instance Remover - Scheduled Service", metatype=true, configurationFactory=true)
@Properties(value={@Property(label="Cron expression defining when this Scheduled Service will run", description="[12:01am daily = 0 1 0 ? * *]; see www.cronmaker.com", name="scheduler.expression", value={"0 1 0 ? * *"}), @Property(label="Allow concurrent executions", description="Allow concurrent executions of this Scheduled Service", name="scheduler.concurrent", boolValue={false}, propertyPrivate=true)})
@Service
public class WorkflowInstanceRemoverScheduler
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(WorkflowInstanceRemoverScheduler.class);
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private WorkflowInstanceRemover workflowInstanceRemover;
    private static final String[] DEFAULT_WORKFLOW_STATUSES = new String[]{"COMPLETE", "ABORTED"};
    private List<String> statuses = new ArrayList<String>();
    @Property(label="Workflow Status", description="Only remove Workflow Instances that have one of these statuses.", value={"COMPLETE", "ABORTED"})
    public static final String PROP_WORKFLOW_STATUSES = "workflow.statuses";
    private static final String[] DEFAULT_WORKFLOW_MODELS = new String[0];
    private List<String> models = new ArrayList<String>();
    @Property(label="Workflow Models", description="Only remove Workflow Instances that belong to one of these WF Models.", value={})
    public static final String PROP_WORKFLOW_MODELS = "workflow.models";
    private static final String[] DEFAULT_WORKFLOW_PAYLOADS = new String[0];
    private List<Pattern> payloads = new ArrayList<Pattern>();
    @Property(label="Payload Patterns", description="Only remove Workflow Instances whose payloads match one of these regex patterns", value={})
    public static final String PROP_WORKFLOW_PAYLOADS = "workflow.payloads";
    private Calendar olderThan = null;
    @Property(label="Older Than UTC TS", description="Only remove Workflow Instances whose payloads are older than this UTC Time in Millis", longValue={0L})
    public static final String PROP_WORKFLOWS_OLDER_THAN = "workflow.older-than";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        ResourceResolver adminResourceResolver = null;
        try {
            adminResourceResolver = this.resourceResolverFactory.getAdministrativeResourceResolver(null);
            long start = System.currentTimeMillis();
            int count = this.workflowInstanceRemover.removeWorkflowInstances(adminResourceResolver, this.models, this.statuses, this.payloads, this.olderThan);
            log.info("Removed [ {} ] Workflow instances in {} ms", (Object)count, (Object)(System.currentTimeMillis() - start));
        }
        catch (LoginException e) {
            log.error("Login Exception when getting admin resource resolver", (Throwable)e);
        }
        catch (PersistenceException e) {
            log.error("Persistence Exception when saving Workflow Instances removal", (Throwable)e);
        }
        catch (WorkflowRemovalException e) {
            log.warn("Workflow Removal Exception occurred preventing the removal process from starting.", (Throwable)e);
        }
        finally {
            if (adminResourceResolver != null) {
                adminResourceResolver.close();
            }
        }
    }

    @Activate
    protected final void activate(Map<String, String> config) {
        String[] payloadsArray;
        this.statuses = Arrays.asList(PropertiesUtil.toStringArray((Object)config.get(PROP_WORKFLOW_STATUSES), (String[])DEFAULT_WORKFLOW_STATUSES));
        this.models = Arrays.asList(PropertiesUtil.toStringArray((Object)config.get(PROP_WORKFLOW_MODELS), (String[])DEFAULT_WORKFLOW_MODELS));
        for (String payload : payloadsArray = PropertiesUtil.toStringArray((Object)config.get(PROP_WORKFLOW_PAYLOADS), (String[])DEFAULT_WORKFLOW_PAYLOADS)) {
            Pattern p = Pattern.compile(payload);
            if (p == null) continue;
            this.payloads.add(p);
        }
        Long olderThanTs = PropertiesUtil.toLong((Object)config.get(PROP_WORKFLOWS_OLDER_THAN), (long)0L);
        if (olderThanTs > 0L) {
            this.olderThan = Calendar.getInstance();
            this.olderThan.setTimeInMillis(olderThanTs);
        }
    }

    @Deactivate
    protected final void deactivate(Map<String, String> config) {
        this.olderThan = null;
        this.statuses = new ArrayList<String>();
        this.models = new ArrayList<String>();
        this.payloads = new ArrayList<Pattern>();
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindWorkflowInstanceRemover(WorkflowInstanceRemover workflowInstanceRemover) {
        this.workflowInstanceRemover = workflowInstanceRemover;
    }

    protected void unbindWorkflowInstanceRemover(WorkflowInstanceRemover workflowInstanceRemover) {
        if (this.workflowInstanceRemover == workflowInstanceRemover) {
            this.workflowInstanceRemover = null;
        }
    }
}

