/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.workflow.synthetic.impl;

import com.adobe.acs.commons.workflow.synthetic.SyntheticWorkflowRunner;
import com.adobe.acs.commons.workflow.synthetic.impl.SyntheticMetaDataMap;
import com.adobe.acs.commons.workflow.synthetic.impl.SyntheticWorkItem;
import com.adobe.acs.commons.workflow.synthetic.impl.SyntheticWorkflow;
import com.adobe.acs.commons.workflow.synthetic.impl.SyntheticWorkflowData;
import com.adobe.acs.commons.workflow.synthetic.impl.SyntheticWorkflowSession;
import com.adobe.acs.commons.workflow.synthetic.impl.exceptions.SyntheticRestartWorkflowException;
import com.adobe.acs.commons.workflow.synthetic.impl.exceptions.SyntheticTerminateWorkflowException;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.exec.WorkflowProcess;
import com.day.cq.workflow.metadata.MetaDataMap;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="ACS AEM Commons - Synthetic Workflow Runner", description="Facilitates the execution of synthetic workflow.")
@Reference(name="workflowProcesses", referenceInterface=WorkflowProcess.class, policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE)
@Service(value={SyntheticWorkflowRunner.class})
public class SyntheticWorkflowRunnerImpl
implements SyntheticWorkflowRunner {
    private static final Logger log = LoggerFactory.getLogger(SyntheticWorkflowRunnerImpl.class);
    private static final String UNSUPPORTED_OPERATION_MESSAGE = "Operation not supported by Synthetic Workflow";
    private static final String WORKFLOW_PROCESS_LABEL = "process.label";
    private static final int MAX_RESTART_COUNT = 3;
    private Map<String, WorkflowProcess> workflowProcesses = new ConcurrentHashMap<String, WorkflowProcess>();

    @Override
    public final void execute(ResourceResolver resourceResolver, String payloadPath, String[] workflowProcessLabels) throws WorkflowException {
        this.execute(resourceResolver, payloadPath, workflowProcessLabels, null, false, false);
    }

    @Override
    public final void execute(ResourceResolver resourceResolver, String payloadPath, String[] workflowProcessLabels, Map<String, Map<String, Object>> processArgs, boolean autoSaveAfterEachWorkflowProcess, boolean autoSaveAtEnd) throws WorkflowException {
        long start = System.currentTimeMillis();
        if (processArgs == null) {
            processArgs = new HashMap<String, Map<String, Object>>();
        }
        int count = 0;
        while (true) {
            ++count;
            try {
                this.run(resourceResolver, payloadPath, workflowProcessLabels, processArgs, autoSaveAfterEachWorkflowProcess, autoSaveAtEnd);
                if (log.isInfoEnabled()) {
                    long duration = System.currentTimeMillis() - start;
                    log.info("Synthetic workflow execution of payload [ {} ] completed in [ {} ] ms", (Object)payloadPath, (Object)duration);
                }
                return;
            }
            catch (SyntheticRestartWorkflowException ex) {
                if (count < 3) {
                    log.info("Restarting synthetic workflow for [ {} ]", (Object)payloadPath);
                    continue;
                }
                log.warn("Synthetic workflow execution of payload [ {} ] reached max restart rate of [ {} ]", (Object)payloadPath, (Object)count);
                if (count < 3) continue;
                return;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(ResourceResolver resourceResolver, String payloadPath, String[] workflowProcessLabels, Map<String, Map<String, Object>> metaDataMaps, boolean autoSaveAfterEachWorkflowProcess, boolean autoSaveAtEnd) throws WorkflowException {
        Session session = (Session)resourceResolver.adaptTo(Session.class);
        WorkflowSession workflowSession = this.getWorkflowSession(session);
        SyntheticWorkflowData workflowData = new SyntheticWorkflowData("JCR_PATH", payloadPath);
        SyntheticWorkflow workflow = new SyntheticWorkflow("Synthetic Workflow: " + payloadPath, workflowData);
        for (String workflowProcessLabel : workflowProcessLabels) {
            WorkflowProcess workflowProcess = this.workflowProcesses.get(workflowProcessLabel);
            if (workflowProcess != null) {
                SyntheticWorkItem workItem = new SyntheticWorkItem(workflowData);
                workItem.setWorkflow(workflow);
                SyntheticMetaDataMap workflowProcessMetaDataMap = new SyntheticMetaDataMap(metaDataMaps.get(workflowProcessLabel));
                try {
                    workflowProcess.execute((WorkItem)workItem, workflowSession, (MetaDataMap)workflowProcessMetaDataMap);
                    workItem.setTimeEnded(new Date());
                    log.trace("Synthetic workflow execution of [ {} ] executed in [ {} ] ms", (Object)workflowProcessLabel, (Object)(workItem.getTimeEnded().getTime() - workItem.getTimeStarted().getTime()));
                    continue;
                }
                catch (SyntheticTerminateWorkflowException ex) {
                    log.info("Synthetic workflow execution stopped via terminate() for [ {} ]", (Object)payloadPath);
                    break;
                }
                finally {
                    try {
                        if (autoSaveAfterEachWorkflowProcess && session.hasPendingChanges()) {
                            session.save();
                        }
                    }
                    catch (RepositoryException e) {
                        log.error("Could not save at end of synthetic workflow execution process [ {} ] for payload path [ {} ]", (Object)workflowProcessLabel, (Object)payloadPath);
                        log.error("Synthetic Workflow process save failed.", (Throwable)e);
                        throw new WorkflowException((Throwable)e);
                    }
                }
            }
            log.error("Synthetic workflow runner retrieved a null Workflow Process for process.label [ {} ]", (Object)workflowProcessLabel);
        }
        try {
            if (autoSaveAtEnd && session.hasPendingChanges()) {
                session.save();
            }
        }
        catch (RepositoryException e) {
            log.error("Could not complete save at end of synthetic workflow execution process [ {} ]", (Object)payloadPath, (Object)e);
            throw new WorkflowException((Throwable)e);
        }
    }

    public final void start() throws WorkflowException {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION_MESSAGE);
    }

    public final void stop() {
        throw new UnsupportedOperationException(UNSUPPORTED_OPERATION_MESSAGE);
    }

    public final WorkflowSession getWorkflowSession(Session session) {
        return new SyntheticWorkflowSession(this, session);
    }

    @Deprecated
    public final Dictionary<String, Object> getConfig() {
        return new Hashtable<String, Object>();
    }

    @Deactivate
    protected final void deactivate(Map<String, Object> config) {
        log.trace("Deactivating Synthetic Workflow Runner");
        this.workflowProcesses = new ConcurrentHashMap<String, WorkflowProcess>();
    }

    protected final void bindWorkflowProcesses(WorkflowProcess service, Map<Object, Object> props) {
        String label = PropertiesUtil.toString((Object)props.get(WORKFLOW_PROCESS_LABEL), null);
        if (label != null) {
            this.workflowProcesses.put(label, service);
            log.debug("Synthetic Workflow Runner added Workflow Process [ {} ]", (Object)label);
        }
    }

    protected final void unbindWorkflowProcesses(WorkflowProcess service, Map<Object, Object> props) {
        String label = PropertiesUtil.toString((Object)props.get(WORKFLOW_PROCESS_LABEL), null);
        if (label != null) {
            this.workflowProcesses.remove(label);
            log.debug("Synthetic Workflow Runner removed Workflow Process [ {} ]", (Object)label);
        }
    }
}

