/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.email.process.impl;

import com.adobe.acs.commons.email.EmailService;
import com.adobe.acs.commons.email.process.impl.SendTemplatedEmailUtils;
import com.adobe.acs.commons.wcm.AuthorUIHelper;
import com.day.cq.commons.Externalizer;
import com.day.cq.dam.commons.util.DamUtil;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.exec.WorkflowData;
import com.day.cq.workflow.exec.WorkflowProcess;
import com.day.cq.workflow.metadata.MetaDataMap;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="ACS AEM Commons - Workflow Process - Send Templated Email Workflow Process", description="Uses the Email Service api to send an email based on workflow arguments")
@Properties(value={@Property(label="Workflow Label", name="process.label", value={"Send Templated Email"}, description="Sends a templated email using the ACS Commons Email Service")})
@Service
public class SendTemplatedEmailProcess
implements WorkflowProcess {
    private static final Logger log = LoggerFactory.getLogger(SendTemplatedEmailProcess.class);
    @Reference
    private EmailService emailService;
    @Reference
    private AuthorUIHelper authorUIHelper;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    @Reference
    private Externalizer externalizer;

    public final void execute(WorkItem workItem, WorkflowSession workflowSession, MetaDataMap metaData) throws WorkflowException {
        WorkflowData workflowData = workItem.getWorkflowData();
        String type = workflowData.getPayloadType();
        if (!StringUtils.equals((String)type, (String)"JCR_PATH")) {
            return;
        }
        String[] args = this.buildArguments(metaData);
        String emailTemplate = this.getValueFromArgs(Arguments.TEMPLATE.getArgumentName(), args);
        if (emailTemplate == null) {
            log.warn("Invalid process arguments, returning");
            return;
        }
        String sdfParam = this.getValueFromArgs(Arguments.DATE_FORMAT.getArgumentName(), args);
        SimpleDateFormat sdf = this.getSimpleDateFormat(sdfParam);
        String payloadPath = workflowData.getPayload().toString();
        HashMap<String, Session> authInfo = new HashMap<String, Session>();
        authInfo.put("user.jcr.session", workflowSession.getSession());
        try {
            String[] emailTo;
            List<String> failureList;
            Map<String, String> wfParams;
            Map<String, String> urlParams;
            ResourceResolver resourceResolver = this.resourceResolverFactory.getResourceResolver(authInfo);
            Resource payloadRes = resourceResolver.getResource(payloadPath);
            HashMap<String, String> emailParams = new HashMap<String, String>();
            emailParams.put("jcr:Path", payloadPath);
            Map<String, String> payloadProp = SendTemplatedEmailUtils.getPayloadProperties(payloadRes, sdf);
            if (payloadProp != null) {
                emailParams.putAll(payloadProp);
            }
            if ((urlParams = this.getURLs(payloadRes)) != null) {
                emailParams.putAll(urlParams);
            }
            if ((wfParams = this.getAdditionalParams(workItem, workflowSession, payloadRes)) != null) {
                emailParams.putAll(wfParams);
            }
            if ((failureList = this.emailService.sendEmail(emailTemplate, emailParams, emailTo = this.getEmailAddrs(workItem, payloadRes, args))).isEmpty()) {
                log.info("Email sent successfully to {} recipients", (Object)emailTo.length);
            } else {
                log.error("Email sent failed");
            }
        }
        catch (LoginException e) {
            log.error("Could not acquire a ResourceResolver object from the Workflow Session's JCR Session: {}", (Throwable)e);
        }
    }

    protected String[] getEmailAddrs(WorkItem workItem, Resource payloadResource, String[] args) {
        ResourceResolver resolver = payloadResource.getResourceResolver();
        String sendToUser = this.getValueFromArgs(Arguments.SEND_TO.getArgumentName(), args);
        return SendTemplatedEmailUtils.getEmailAddrsFromUserPath(resolver, sendToUser);
    }

    protected Map<String, String> getAdditionalParams(WorkItem workItem, WorkflowSession workflowSession, Resource payloadResource) {
        HashMap<String, String> wfParams = new HashMap<String, String>();
        try {
            wfParams.put("wfStepTitle", workItem.getNode().getTitle());
            wfParams.put("wfModelTitle", workItem.getWorkflow().getWorkflowModel().getTitle());
        }
        catch (Exception e) {
            log.warn("Error getting workflow title and workflow step title {}", (Throwable)e);
        }
        return wfParams;
    }

    protected String getValueFromArgs(String key, String[] arguments) {
        for (String str : arguments) {
            String trimmedStr = str.trim();
            if (!trimmedStr.startsWith(key + ":")) continue;
            return trimmedStr.substring((key + ":").length());
        }
        return null;
    }

    private Map<String, String> getURLs(Resource payloadRes) {
        HashMap<String, String> urlParams = new HashMap<String, String>();
        if (payloadRes == null) {
            return urlParams;
        }
        String payloadPath = payloadRes.getPath();
        ResourceResolver resolver = payloadRes.getResourceResolver();
        if (DamUtil.isAsset((Resource)payloadRes)) {
            String assetDetailsUrl = this.authorUIHelper.generateEditAssetLink(payloadPath, true, resolver);
            urlParams.put("authorLink", assetDetailsUrl);
            String publishUrl = this.externalizer.publishLink(resolver, payloadPath);
            urlParams.put("publishLink", publishUrl);
        } else {
            String assetDetailsUrl = this.authorUIHelper.generateEditPageLink(payloadPath, true, resolver);
            urlParams.put("authorLink", assetDetailsUrl);
            String publishUrl = this.externalizer.publishLink(resolver, payloadPath + ".html");
            urlParams.put("publishLink", publishUrl);
        }
        return urlParams;
    }

    private String[] buildArguments(MetaDataMap metaData) {
        String processArgs = (String)metaData.get(Arguments.PROCESS_ARGS.getArgumentName(), String.class);
        if (processArgs != null && !processArgs.equals("")) {
            return processArgs.split(",");
        }
        return new String[0];
    }

    private SimpleDateFormat getSimpleDateFormat(String formatString) {
        SimpleDateFormat defaultFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm a");
        if (formatString == null || formatString.isEmpty()) {
            return defaultFormat;
        }
        try {
            return new SimpleDateFormat(formatString);
        }
        catch (IllegalArgumentException e) {
            return defaultFormat;
        }
    }

    @Activate
    protected void activate(ComponentContext context) throws RepositoryException {
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
    }

    protected void bindEmailService(EmailService emailService) {
        this.emailService = emailService;
    }

    protected void unbindEmailService(EmailService emailService) {
        if (this.emailService == emailService) {
            this.emailService = null;
        }
    }

    protected void bindAuthorUIHelper(AuthorUIHelper authorUIHelper) {
        this.authorUIHelper = authorUIHelper;
    }

    protected void unbindAuthorUIHelper(AuthorUIHelper authorUIHelper) {
        if (this.authorUIHelper == authorUIHelper) {
            this.authorUIHelper = null;
        }
    }

    protected void bindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resourceResolverFactory = resourceResolverFactory;
    }

    protected void unbindResourceResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.resourceResolverFactory == resourceResolverFactory) {
            this.resourceResolverFactory = null;
        }
    }

    protected void bindExternalizer(Externalizer externalizer) {
        this.externalizer = externalizer;
    }

    protected void unbindExternalizer(Externalizer externalizer) {
        if (this.externalizer == externalizer) {
            this.externalizer = null;
        }
    }

    protected static enum Arguments {
        PROCESS_ARGS("PROCESS_ARGS"),
        TEMPLATE("emailTemplate"),
        SEND_TO("sendTo"),
        DATE_FORMAT("dateFormat");

        private String argumentName;

        private Arguments(String argumentName) {
            this.argumentName = argumentName;
        }

        public String getArgumentName() {
            return this.argumentName;
        }
    }
}

