/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.forms;

import aQute.bnd.annotation.ProviderType;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ProviderType
public class Form {
    private static final Logger log = LoggerFactory.getLogger(Form.class);
    private final Map<String, String> data;
    private final Map<String, String> errors;
    private String name;
    private String resourcePath;

    public Form(String name, String resourcePath) {
        this.name = name;
        this.resourcePath = resourcePath;
        this.data = new HashMap<String, String>();
        this.errors = new HashMap<String, String>();
    }

    public Form(String name, String resourcePath, Map<String, String> data) {
        this.name = name;
        this.resourcePath = resourcePath;
        this.data = data;
        this.errors = new HashMap<String, String>();
    }

    public Form(String name, String resourcePath, Map<String, String> data, Map<String, String> errors) {
        this.name = name;
        this.resourcePath = resourcePath;
        this.data = data;
        this.errors = errors;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    public Map<String, String> getData() {
        return this.data;
    }

    public Map<String, String> getErrors() {
        return this.errors;
    }

    public boolean has(String key) {
        String val = this.get(key);
        return StringUtils.isNotBlank((String)val);
    }

    public String get(String key) {
        String val = this.data.get(key);
        return StringUtils.stripToEmpty((String)val);
    }

    public void set(String key, String value) {
        this.data.put(key, value);
    }

    public boolean hasData() {
        if (!this.data.isEmpty()) {
            return false;
        }
        for (String key : this.data.keySet()) {
            if (!this.has(key)) continue;
            return true;
        }
        return false;
    }

    public boolean hasError(String key) {
        return this.errors.containsKey(key);
    }

    public String getError(String key) {
        String val = this.errors.get(key);
        return StringUtils.stripToEmpty((String)val);
    }

    public void setError(String key) {
        this.errors.put(key, null);
    }

    public void setError(String key, String value) {
        this.errors.put(key, value);
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public ValueMap getValueMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.putAll(this.data);
        return new ValueMapDecorator(map);
    }

    public ValueMap getErrorsValueMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.putAll(this.errors);
        return new ValueMapDecorator(map);
    }
}

