/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.genericlists.impl;

import com.adobe.acs.commons.genericlists.GenericList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;

public final class GenericListImpl
implements GenericList {
    static final String TMPL_GENERIC_LIST = "/apps/acs-commons/templates/utilities/genericlist";
    static final String PN_VALUE = "value";
    static final String TITLE_PREFIX = "jcr:title.";
    private final List<GenericList.Item> items;
    private final Map<String, GenericList.Item> valueMapping;

    public GenericListImpl(Resource listParsys) {
        ArrayList<ItemImpl> tempItems = new ArrayList<ItemImpl>();
        HashMap<String, ItemImpl> tempValueMapping = new HashMap<String, ItemImpl>();
        Iterator children = listParsys.listChildren();
        while (children.hasNext()) {
            Resource res = (Resource)children.next();
            ValueMap map = ResourceUtil.getValueMap((Resource)res);
            String title = (String)map.get("jcr:title", String.class);
            String value = (String)map.get(PN_VALUE, String.class);
            if (title == null || value == null) continue;
            ItemImpl item = new ItemImpl(title, value, map);
            tempItems.add(item);
            tempValueMapping.put(value, item);
        }
        this.items = Collections.unmodifiableList(tempItems);
        this.valueMapping = Collections.unmodifiableMap(tempValueMapping);
    }

    @Override
    public List<GenericList.Item> getItems() {
        return this.items;
    }

    @Override
    public String lookupTitle(String value) {
        GenericList.Item item = this.valueMapping.get(value);
        if (item != null) {
            return item.getTitle();
        }
        return null;
    }

    @Override
    public String lookupTitle(String value, Locale locale) {
        GenericList.Item item = this.valueMapping.get(value);
        if (item != null) {
            return item.getTitle();
        }
        return null;
    }

    public static final class ItemImpl
    implements GenericList.Item {
        private final String title;
        private final String value;
        private final ValueMap props;

        public ItemImpl(String t, String v, ValueMap props) {
            this.title = t;
            this.value = v;
            this.props = props;
        }

        @Override
        public String getTitle() {
            return this.title;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public String getTitle(Locale locale) {
            if (locale == null) {
                return this.getTitle();
            }
            String language = locale.getLanguage();
            if (language.length() == 0) {
                return this.getTitle();
            }
            String title = null;
            if (locale.getCountry().length() > 0) {
                title = this.getLocalizedTitle(locale);
            }
            if (title == null) {
                title = this.getLocalizedTitle(new Locale(language));
            }
            if (title == null) {
                return this.getTitle();
            }
            return title;
        }

        private String getLocalizedTitle(Locale locale) {
            return (String)this.props.get(GenericListImpl.TITLE_PREFIX + locale.toString().toLowerCase(), String.class);
        }
    }
}

