/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.commons.genericlists.impl;

import com.adobe.acs.commons.genericlists.GenericList;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceProvider;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.SyntheticResource;
import org.apache.sling.commons.json.io.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
@Properties(value={@Property(name="provider.roots", value={"/mnt/acs-commons/lists"}), @Property(name="provider.ownsRoots", boolValue={true})})
public final class GenericListJsonResourceProvider
implements ResourceProvider {
    private static final Logger log = LoggerFactory.getLogger(GenericListJsonResourceProvider.class);
    static final String ROOT = "/mnt/acs-commons/lists";
    static final String LIST_ROOT = "/etc/acs-commons/lists";
    private static final String EXTENSION = ".json";
    private static final int EXTENSION_LENGTH = ".json".length();

    public Resource getResource(ResourceResolver resourceResolver, HttpServletRequest request, String path) {
        return this.getResource(resourceResolver, path);
    }

    public Resource getResource(ResourceResolver resourceResolver, String path) {
        if (path == null) {
            return null;
        }
        if (path.equals(ROOT)) {
            return null;
        }
        String listPath = path.endsWith(EXTENSION) ? path.substring(ROOT.length(), path.length() - EXTENSION_LENGTH) : path.substring(ROOT.length());
        String fullListPath = LIST_ROOT + listPath;
        Page listPage = ((PageManager)resourceResolver.adaptTo(PageManager.class)).getPage(fullListPath);
        if (listPage == null) {
            return null;
        }
        GenericList list = (GenericList)listPage.adaptTo(GenericList.class);
        if (list == null) {
            return null;
        }
        ResourceMetadata rm = new ResourceMetadata();
        rm.setResolutionPath(path);
        return new JsonResource(list, resourceResolver, rm);
    }

    public Iterator<Resource> listChildren(Resource parent) {
        return null;
    }

    private static class JsonResource
    extends SyntheticResource {
        private GenericList list;

        public JsonResource(GenericList list, ResourceResolver resourceResolver, ResourceMetadata rm) {
            super(resourceResolver, rm, "acs-commons/components/utilities/genericlist/json");
            this.list = list;
        }

        public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
            if (type == InputStream.class) {
                StringWriter buffer = new StringWriter();
                try {
                    JSONWriter writer = new JSONWriter((Writer)buffer);
                    writer.object();
                    writer.key("options");
                    writer.array();
                    for (GenericList.Item item : this.list.getItems()) {
                        writer.object();
                        writer.key("text").value((Object)item.getTitle());
                        writer.key("value").value((Object)item.getValue());
                        writer.endObject();
                    }
                    writer.endArray();
                    writer.endObject();
                    return (AdapterType)new ByteArrayInputStream(buffer.toString().getBytes("UTF-8"));
                }
                catch (Exception e) {
                    log.warn("Unable to generate JSON object.", (Throwable)e);
                    return null;
                }
            }
            return (AdapterType)super.adaptTo(type);
        }
    }
}

